/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalculatorCpmService {
    private static final Logger log = LoggerFactory.getLogger(CalculatorCpmService.class);
    @Autowired
    private BidStatService bidStatService;
    public static final String DEFAULT_PCTR = "0.20";
    public static final String DEFAULT_PCVR = "0.10";

    public double cpc2Cpm(Double price, AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        ResourceIdeaDto resourceIdeaDto = this.bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
        if (resourceIdeaDto == null) {
            return 0.0;
        }
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());
        Double pCtr = this.bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        double factor = this.bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        SamplerLog.info((String)"cpc2Cpm appId is {} slotId is {} resourceId is {} ideaId is {} cpcPrice is {} pctr is {} factor is {}", (Object[])new Object[]{appId, slotId, resourceId, ideaId, price, pCtr, factor});
        return price * pCtr * 1000.0 * factor;
    }

    public double calculateOcpm(AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        ResourceIdeaDto resourceIdeaDto = this.bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
        if (resourceIdeaDto == null) {
            return 0.0;
        }
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());
        Double pCtr = this.bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        double pCvr = this.bidStatService.getPCvr(resourceId, ideaId, appId, slotId);
        double factor = this.bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        if (pCvr == 0.0) {
            pCvr = Double.parseDouble(DEFAULT_PCVR);
        }
        Double targetPrice = resourceIdeaDto.getIdeaPriceStrategyDTO().getTargetPrice();
        SamplerLog.info((String)"calculateOcpm appId is {} slotId is {} resourceId is {} ideaId is {} targetPrice is {} pctr is {} pcvr is {} factor is {}", (Object[])new Object[]{appId, slotId, resourceId, ideaId, targetPrice, pCtr, pCvr, factor});
        return targetPrice * 100.0 * pCtr * pCvr * factor * 1000.0;
    }

    public double calculateOcpc(ResourceIdeaDto resourceIdeaDto, AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        CommonCreative commonCreative = commonSeatBid.getCommonCreative();
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String dspTaskId = commonCreative.getDspTaskId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());
        String dspId = String.valueOf(resourceIdeaDto.getDspId());
        String dspTagId = resourceIdeaDto.getDspTagId();
        double pCvr = this.bidStatService.getQiHangPCvr(resourceId, ideaId, dspTaskId, dspId, dspTagId);
        double pCtr = this.bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        Double targetPrice = resourceIdeaDto.getIdeaPriceStrategyDTO().getTargetPrice();
        double factor = this.bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        Integer dspPriceRatio = resourceIdeaDto.getDspPriceRatio();
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        if (pCvr == 0.0) {
            pCvr = Double.parseDouble(DEFAULT_PCVR);
        }
        double cpcPrice = targetPrice * 100.0 * pCvr * factor;
        if (dspPriceRatio != null) {
            cpcPrice = cpcPrice * (1.0 - (double)dspPriceRatio.intValue() / 100.0) + commonSeatBid.getPrice() * (double)dspPriceRatio.intValue() / 100.0 * factor;
        }
        commonSeatBid.setPrice(cpcPrice);
        SamplerLog.info((String)"calculateOcpc appId is {} slotId is {} resourceId is {} ideaId is {} targetPrice is {} pctr is {} pcvr is {} factor is {}", (Object[])new Object[]{appId, slotId, resourceId, ideaId, targetPrice, pCtr, pCvr, factor});
        return targetPrice * 100.0 * pCtr * pCvr * factor * 1000.0;
    }
}

