package cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.proto.FeiSuoProtoBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.protobuf.ProtocolStringList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
public class FeiSuoDspRespConvert {


    public AdxCommonBidResponse convertResp(FeiSuoProtoBid.FlyingShuttleBidResponse flyingShuttleBidResponse) {
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(flyingShuttleBidResponse.getRequestId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_29.getDspId());

        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        List<FeiSuoProtoBid.Ad> adsList = flyingShuttleBidResponse.getAdsList();
        for (FeiSuoProtoBid.Ad ad : adsList) {
            CommonSeatBid commonSeatBid = convertSeatBid(ad);
            commonSeatBidList.add(commonSeatBid);
        }
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return adxCommonBidResponse;
    }

    private CommonSeatBid convertSeatBid(FeiSuoProtoBid.Ad ad) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        commonSeatBid.setPrice(ad.getCpm() * 1.0);
        FeiSuoProtoBid.Material material = ad.getMaterial();
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setLandingPageUrl(material.getLandingUrl());
        if (StringUtils.isNotBlank(material.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(material.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(material.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(material.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }

        FeiSuoProtoBid.MaterialType materialType = ad.getMaterialType();
        String trackingData = ad.getTrackingData();

        if (FeiSuoProtoBid.MaterialType.MATERIAL_TYPE_HORIZONTAL_PIC.equals(materialType)
                || FeiSuoProtoBid.MaterialType.MATERIAL_TYPE_VERTICAL_PIC.equals(materialType)) {
            List<CommonImage> commonImageList = new ArrayList<>();
            //图片
            CommonImage commonImage = new CommonImage();
            FeiSuoProtoBid.Image image = material.getImagesList().get(0);
            commonImage.setUrl(image.getUrl());
            commonImage.setWidth(image.getWidth());
            commonImage.setHeight(image.getHeight());
            commonImageList.add(commonImage);
            commonCreative.setCommonImageList(commonImageList);

        } else if (FeiSuoProtoBid.MaterialType.MATERIAL_TYPE_HORIZONTAL_VIDEO.equals(materialType)
                || FeiSuoProtoBid.MaterialType.MATERIAL_TYPE_VERTICAL_VIDEO.equals(materialType)) {
            //视频
            List<CommonVideo> commonVideoList = new ArrayList<>();
            CommonVideo commonVideo = new CommonVideo();
            FeiSuoProtoBid.Video video = material.getVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            if (CollectionUtils.isNotEmpty(material.getImagesList())) {
                commonVideo.setCoverUrl(material.getImagesList().get(0).getUrl());
                commonVideo.setCoverWidth(video.getWidth());
                commonVideo.setCoverHeight(video.getHeight());
            }
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }

        FeiSuoProtoBid.AdType adType = ad.getAdType();
        if (FeiSuoProtoBid.AdType.AD_TYPE_DEEPLINK.equals(adType)) {
            commonCreative.setDeepLinkUrl(material.getDeeplinkUrl());
        } else if (FeiSuoProtoBid.AdType.AD_TYPE_DOWNLOAD.equals(adType)) {
            FeiSuoProtoBid.TargetApp app = material.getApp();
            commonCreative.setAppName(app.getName());
            commonCreative.setAppVersion(String.valueOf(app.getVersion()));
            commonCreative.setAppBundle(app.getPkgName());
            commonCreative.setIconUrl(app.getIcon());
            commonCreative.setDeveloper(app.getDeveloper());
            commonCreative.setPrivacyPolicyLink(app.getPrivacy());
            commonCreative.setPermissionLink(app.getPermissionUrl());
            commonCreative.setAppBundle(app.getIntroductionUrl());

        } else if (FeiSuoProtoBid.AdType.AD_TYPE_MARKET.equals(adType)) {
            commonCreative.setLandingPageUrl(material.getMarketUrl());
        }

        FeiSuoProtoBid.TrackingUrl trackingUrls = ad.getTrackingUrls();
        ProtocolStringList winUrlsList = trackingUrls.getWinUrlsList();
        List<String> winCallbackUrls = new ArrayList<>();
        for (String s : winUrlsList) {
            s = s.replace("__TRACKING__", trackingData);
            winCallbackUrls.add(s);
        }
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        ProtocolStringList impUrlsList = trackingUrls.getImpUrlsList();
        List<String> impCallbackUrls = new ArrayList<>();
        for (String s : impUrlsList) {
            s = s.replace("__TRACKING__", trackingData);
            impCallbackUrls.add(s);
        }
        commonSeatBid.setExposureCallbackUrls(impCallbackUrls);
        ProtocolStringList clickUrlsList = trackingUrls.getClickUrlsList();
        List<String> clickCallbackUrls = new ArrayList<>();
        for (String s : clickUrlsList) {
            s = s.replace("__TRACKING__", trackingData);
            clickCallbackUrls.add(s);
        }
        commonSeatBid.setClickCallbackUrls(clickCallbackUrls);
        if (FeiSuoProtoBid.AdType.AD_TYPE_DOWNLOAD.equals(adType)) {
            ProtocolStringList downloadStartUrlsList = trackingUrls.getDownloadStartUrlsList();
            List<String> downloadStartCallbackUrls = new ArrayList<>();
            for (String s : downloadStartUrlsList) {
                s = s.replace("__TRACKING__", trackingData);
                downloadStartCallbackUrls.add(s);
            }
            commonSeatBid.setStartDownloadUrls(downloadStartCallbackUrls);
            ProtocolStringList downloadEndUrlsList = trackingUrls.getDownloadEndUrlsList();
            List<String> downloadEndCallbackUrls = new ArrayList<>();
            for (String s : downloadEndUrlsList) {
                s = s.replace("__TRACKING__", trackingData);
                downloadEndCallbackUrls.add(s);
            }
            commonSeatBid.setFinishDownloadUrls(downloadEndCallbackUrls);
            commonSeatBid.setFinishInstallUrls(trackingUrls.getInstallEndUrlsList());
            commonCreative.setLandingPageUrl(material.getDownloadUrl());
        }

        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}
