/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.alipay;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.AlipayProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.convert.AlipayDspReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.convert.AlipayDspRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.proto.AlipayDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.proto.AlipayRelDspReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class AlipayDspInvoker
extends AbstractDspCaller<AlipayDsp.BidResponse, AlipayRelDspReq> {
    private static final Logger log = LoggerFactory.getLogger(AlipayDspInvoker.class);
    @Autowired
    private AlipayDspReqConvert alipayDspReqConvert;
    @Autowired
    private AlipayDspRespConvert alipayDspRespConvert;
    @Autowired
    private AlipayProperties alipayProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;
    @Resource(name="redis03StringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate03;

    @Override
    protected AlipayDsp.BidResponse invokeDsp(AlipayRelDspReq bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u652f\u4ed8\u5b9dDSP\u8c03\u7528");
        try {
            return (AlipayDsp.BidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.alipayProperties.getUrl(), bidRequest), (String)"invokeDSP", (String)"alipay");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u652f\u4ed8\u5b9d_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u652f\u4ed8\u5b9d\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private AlipayDsp.BidResponse doHttpInvoke(String url, AlipayRelDspReq bidRequest) {
        byte[] decompress;
        ResponseEntity resEntity;
        block9: {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
            headers.add("Content-Encoding", "gzip");
            headers.add("Accept", "application/x-protobuf;charset=UTF-8");
            headers.add("Accept-Encoding", "gzip");
            byte[] requestBytes = this.gzipCompress(bidRequest.getBidRequest().toByteArray());
            if (requestBytes == null) {
                return null;
            }
            HttpEntity httpEntity = new HttpEntity((Object)requestBytes, (MultiValueMap)headers);
            resEntity = null;
            try {
                resEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof RestClientException) break block9;
                log.warn("\u652f\u4ed8\u5b9d\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        byte[] body = (byte[])resEntity.getBody();
        AlipayDsp.BidResponse response = null;
        if (body != null && (decompress = this.gzipDecompress(body)) != null) {
            try {
                response = AlipayDsp.BidResponse.parseFrom(decompress);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (response != null && CollectionUtils.isNotEmpty(response.getSeatBidList())) {
            SamplerLog.info((String)"\u652f\u4ed8\u5b9d DSP\u8fd4\u56de {}", (Object[])new Object[]{resEntity});
            return response;
        }
        if (response != null && response.getNbr() == 9) {
            this.stringRedisTemplate03.opsForValue().set((Object)("alipay_nbr9_" + bidRequest.getDeviceId()), (Object)"", response.getColdEndTime(), TimeUnit.SECONDS);
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("ysDusbwFux32RAfJ".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex);
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.warn("\u652f\u4ed8\u5b9d\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_25.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_25;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            return url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public AlipayRelDspReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        AlipayDsp.BidRequest request = this.alipayDspReqConvert.convert(adxCommonBidRequest, dspInfo);
        AlipayRelDspReq alipayRelDspReq = new AlipayRelDspReq();
        alipayRelDspReq.setBidRequest(request);
        return alipayRelDspReq;
    }

    @Override
    public AdxCommonBidResponse convertResp(AlipayDsp.BidResponse bidResponse) throws DspException {
        if (bidResponse == null) {
            return null;
        }
        AdxCommonBidResponse convert = this.alipayDspRespConvert.convert(bidResponse);
        convert.setDspId(this.getDspId());
        CommonSeatBid commonSeatBid = convert.getCommonSeatBidList().get(0);
        CommonCreative commonCreative = commonSeatBid.getCommonCreative();
        String deepLinkUrl = commonCreative.getDeepLinkUrl();
        String taskId = this.getTaskId(deepLinkUrl);
        commonCreative.setDspTaskId(taskId);
        return convert;
    }

    private String getTaskId(String deepLinkUrl) {
        if (StringUtils.isBlank((CharSequence)deepLinkUrl)) {
            return null;
        }
        try {
            deepLinkUrl = URLDecoder.decode(deepLinkUrl, StandardCharsets.UTF_8.toString());
            if (deepLinkUrl.contains("taskId")) {
                String[] params;
                for (String param : params = deepLinkUrl.split("&")) {
                    String[] keyValue;
                    if (!param.startsWith("taskId") || (keyValue = param.split("=")).length != 2) continue;
                    return keyValue[1];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private byte[] gzipCompress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private byte[] gzipDecompress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

