package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter.BuLuKenRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter.BuLuKenResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Base64;
import java.util.Objects;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

@Slf4j
@Component
public class BuLuKenDspInvoker extends AbstractDspCaller<BuLuKenBidResponse, BuLuKenBidRequest> {

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Autowired
    private BuLuKenRequestConvert buLuKenRequestConvert;
    @Autowired
    private BuLuKenResponseConvert buLuKenResponseConvert;
    @Autowired
    private BuLuKenProperties buLuKenProperties;

    @Override
    protected BuLuKenBidResponse invokeDsp(BuLuKenBidRequest tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        Cat.logMetricForCount("布鲁肯DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(buLuKenProperties.getUrl(), tanxBiddingRequest), "invokeDSP", "buluken");
        } catch (ResourceAccessException e) {
            log.warn("布鲁肯 DSP,http请求异常,{}", e.getMessage());
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            log.error("布鲁肯 DSP请求失败,{}", e.getMessage());
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            log.error("布鲁肯其他调用异常", e);
            return null;
        }
    }

    private BuLuKenBidResponse doHttpInvoke(String url, BuLuKenBidRequest request) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<BuLuKenBidRequest> requestEntity = new HttpEntity<>(request, headers);
        ResponseEntity<BuLuKenBidResponse> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, BuLuKenBidResponse.class);
        HttpStatus statusCode = resEntity.getStatusCode();
        BuLuKenBidResponse body = resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            } else {
                if (SamplerLog.infoFlag()) {
                    SamplerLog.info("布鲁肯DSP无内容返回,pddRequest[{}],body[{}]", JSONObject.toJSONString(request), JSONObject.toJSONString(body));
                }
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            log.warn("布鲁肯DSP返回5xx,request[{}],body[{}]", JSONObject.toJSONString(request), JSONObject.toJSONString(body));
            return null;
        } else {
            log.warn("布鲁肯DSP返回其他状态码,request[{}],body[{}]", JSONObject.toJSONString(request), JSONObject.toJSONString(body));
            return null;
        }
    }

    private BuLuKenBidResponse handle2xx(BuLuKenBidResponse response) {
        if(Objects.isNull(response)){
            return response;
        }
        if(Objects.nonNull(response.getSeatbid())){
            Cat.logMetricForCount("沫易DSP返回");
        }
        return response;
    }


    @Override
    public String priceEncryption(BigDecimal price) {

        return price.toString();
    }

    public static void main(String[] args) {
        TanxDspInvoker invoker = new TanxDspInvoker();
        String s = invoker.priceEncryption(new BigDecimal("10"));
        System.out.println(s);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_6.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_6;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__WINPRICE__") && price != null) {
            url = url.replaceAll("__WINPRICE__", price);
        }
        if (url.contains("__TS__")) {
            url = url.replaceAll("__TS__", System.currentTimeMillis()+"");
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public BuLuKenBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return buLuKenRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(BuLuKenBidResponse tanxBiddingResponse) throws DspException {
        try {
            return buLuKenResponseConvert.respConvert(tanxBiddingResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}
