package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.dsp.AdxAdvertPriceDto;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;

/**
 * 第三方dsp调用的抽象
 * <p>
 * 不同的第三方dsp在调用的时候，继承该类，实现两个方法即可
 * {@link #callThirdPartyDsp}
 * {@link #function}
 * </>
 *
 * @author Wangpf
 * @date 2022/7/1 10:05 上午
 */
public abstract class AbstractDspInvoker<T> {

    public List<AdxAdvertPriceDto> obtainAdvert(ObtainAdvertReq req) {
        T callThirdPartyDspResult = callThirdPartyDsp(req);
        return convert(callThirdPartyDspResult);
    }

    public List<AdxAdvertPriceDto> convert(T dspResponse) {
        if (dspResponse == null) {
            return Collections.emptyList();
        }

        return function().apply(dspResponse);
    }

    /**
     * 调用第三方dsp拿到出券的结果
     *
     * @return
     */
    protected abstract T callThirdPartyDsp(ObtainAdvertReq req);

    /**
     * 将第三方调用的结果转换成标准券竞价对象{@link AdxAdvertPriceDto}函数
     *
     * @return
     */
    protected abstract Function<T, List<AdxAdvertPriceDto>> function();

    /**
     * 推啊给第三方分配的dspId
     *
     * @return
     */
    protected abstract Long getDspId();
}
