/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.fancy;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.CatUtils;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.FancyDspProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert.FancyReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert.FancyRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class FancyDspInvoker
extends AbstractDspCaller<BidResponse, BidRequest> {
    private static final Logger log = LoggerFactory.getLogger(FancyDspInvoker.class);
    @Autowired
    private FancyReqConvert fancyReqConvert;
    @Autowired
    private FancyRespConvert fancyRespConvert;
    @Autowired
    private FancyDspProperties fancyDspProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u6cdb\u4e3aDSP\u8c03\u7528");
        try {
            return (BidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.fancyDspProperties.getUrl(), bidRequest), (String)"invokeDSP", (String)"fancy");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u6cdb\u4e3a_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                log.warn("\u6cdb\u4e3a\u8c03\u7528\u5f02\u5e38", t);
            }
            return null;
        }
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("Connection", "Keep-Alive");
        HttpEntity request = new HttpEntity((Object)bidRequest, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, BidResponse.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("\u6cdb\u4e3a\u8c03\u7528\u5f02\u5e38 response is {}", (Object)responseEntity, (Object)e);
            }
            return null;
        }
        if (responseEntity.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
            return null;
        }
        SamplerLog.info((String)"\u6cdb\u4e3a response is {}", (Object[])new Object[]{responseEntity.getBody()});
        Cat.logMetricForCount((String)"\u6cdb\u4e3aDSP\u8fd4\u56de");
        return (BidResponse)responseEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_17.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_17;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url.replace("${AUCTION_PRICE}", price);
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.fancyReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse != null && bidResponse.getSeatbid() != null) {
            return this.fancyRespConvert.convert(bidResponse);
        }
        return null;
    }
}

