package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean;

import lombok.Data;

import java.util.List;

@Data
public class Ad {
    //广告类型
    private String adType;
    //物料类型
    private Integer materialType;
    //用户点击后的, 广告交互方式
    private Integer action;
    //广告标题文案，短文案
    private String title;
    //广告描述文案，长文案
    private String desc;
    //图片链接
    private String imageUrl;
    //多图链接
    private List<String> imageUrlList;
    //视频物料
    private Video video;
    //deeplink地址
    private String deeplinkUrl;
    //deeplink类型
    private Integer deeplinkType;
    //落地页地址
    private String landingPageUrl;
    //应用推广信息, 下载类广告可能会有
    private AppPromotion appPromotion;
    //监测上报
    private Tracker tracker;
    //出价, 单位:分, RTB对接方式必传
    private Integer bidPrice;
    //Deal Id, Preferred Deal交易时候, 会返回该值
    private String dealId;
    //竞赢通知回调接口, RTB对接方式必传
    private String winNoticeUrl;
    //竞败通知回调接口, RTB对接方式可能会传, 需要根据下面的描述进行部分宏的替换
    private String lossNoticeUrl;
    //广告来源标识, eg. 百度
    private String adSource;
    //互动广告样式
    private Integer interactStyle;
    //互动广告玩法
    private Integer interactSubStyle;
    //撒花掉落效果icon集合
    private String[] dropEffectIcons;
    //微信小程序id, 当action为小程序时有值
    private String wechatId;
    //微信小程序唤起路径
    private String wechatPath;
    //安卓下载广告, 采用的下载类型
    private Integer downloadType;
}
