package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;


import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author lizhiheng
 */
@Service
public class IqiyiReqConvert {
    @Resource
    private AppReplace appReplace;

    public IqiyiBid.BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        IqiyiBid.BidRequest.Builder bidRequest = IqiyiBid.BidRequest.newBuilder();
        bidRequest.setId(adxCommonBidRequest.getRequestId());
        bidRequest.setTimestamp(System.currentTimeMillis());

        // Imp 转换
        IqiyiBid.BidRequest.Imp imp = impConvert(adxCommonBidRequest, dspInfo);
        bidRequest.addImp(imp);

        // 资源类型，这里假设根据 appInfo 存在与否判断
        bidRequest.setResourcetype(adxCommonBidRequest.getAppInfo() != null ? 1 : 0);

        // Site 和 App 转换
        if (bidRequest.getResourcetype() == 0) {
            // 假设这里没有站点信息，实际可根据需求完善
            bidRequest.setSite(IqiyiBid.BidRequest.Site.newBuilder().build());
        } else {
            IqiyiBid.BidRequest.App app = appConvert(adxCommonBidRequest.getAppInfo(), dspInfo);
            bidRequest.setApp(app);
        }

        // Device 转换
        IqiyiBid.BidRequest.Device device = deviceConvert(adxCommonBidRequest);
        if (device == null) {
            return null;
        }
        bidRequest.setDevice(device);

        if (adxCommonBidRequest.getUserInfo() != null && adxCommonBidRequest.getUserInfo().getAppList() != null) {
            IqiyiBid.BidRequest.User.Builder user = IqiyiBid.BidRequest.User.newBuilder();
            StringBuilder appList = new StringBuilder();
            for (String app : adxCommonBidRequest.getUserInfo().getAppList()) {
                appList.append(app).append(",");
            }
            //删除最后一个逗号
            if (StringUtils.isNotBlank(appList)) {
                appList.deleteCharAt(appList.length() - 1);
            }
            user.setApplist(appList.toString());
            bidRequest.setUser(user);
        }
        // 去重 ID 转换，假设这里没有去重需求，实际可根据需求完善
        return bidRequest.build();
    }

    private IqiyiBid.BidRequest.Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {

        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        IqiyiBid.BidRequest.Imp.Builder imp = IqiyiBid.BidRequest.Imp.newBuilder();
        imp.setAdzoneId(dspInfo.getDspTagId());
//        imp.setMedia_adzone_id(commonImp.getMediaAdzoneId());
        imp.setAdType(IqiyiBid.BidRequest.Imp.AdType.forNumber(Integer.parseInt(dspInfo.getDspResId())));
        imp.setMediaAdzoneId(dspInfo.getIdeaId() + BlowfishUtils.encryptBlowfish(adxCommonBidRequest.getAppInfo().getBundle(), "abc"));
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidfloor((int) floorPrice);
        if (IqiyiBid.BidRequest.Imp.AdType.OPENING.equals(imp.getAdType())) {
            return imp.build();
        }

        // 贴片
        if (IqiyiBid.BidRequest.Imp.AdType.ROLL.equals(imp.getAdType())) {
            IqiyiBid.BidRequest.Imp.Video video = videoConvert(commonImp);
            imp.setVideo(video);
        }
        //信息流
        if (IqiyiBid.BidRequest.Imp.AdType.FEEDS.equals(imp.getAdType())) {
            IqiyiBid.BidRequest.Imp.Native nativeAd = nativeConvert(commonImp);
            imp.setNative(nativeAd);
        }

        return imp.build();
    }

    private IqiyiBid.BidRequest.Imp.Video videoConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Video.Builder video = IqiyiBid.BidRequest.Imp.Video.newBuilder();
        // 假设广告展现样式为线性贴片
        video.setLinearity(IqiyiBid.BidRequest.Imp.Video.VideoLinearity.LINEAR);
//        List<Integer> acceptedCreativeTypes = new ArrayList<>();
//        acceptedCreativeTypes.add(2); // 视频
        video.setAcceptedCreativeTypes(2);

        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        video.setW(commonSizeInfo.getWidth());
        video.setH(commonSizeInfo.getHeight());
        video.setMinduration(commonSizeInfo.getMinduration());
        video.setMaxduration(commonSizeInfo.getMaxduration());
        // 假设为前贴
        video.setStartdelay(0);
        video.setMaxadscount(1);
        // 假设视频格式为 MP4
        video.setFormat(IqiyiBid.BidRequest.Imp.VideoFormat.VIDEO_MP4);

        return video.build();
    }

    private IqiyiBid.BidRequest.Imp.Native nativeConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Native.Builder nativeAd = IqiyiBid.BidRequest.Imp.Native.newBuilder();
        // 假设最大标题长度为 100
        nativeAd.setTitleLen(24);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        if (commonSizeInfo.getType() == 1) {
            IqiyiBid.BidRequest.Imp.Native.Image.Builder image = IqiyiBid.BidRequest.Imp.Native.Image.newBuilder();
            image.setType(IqiyiBid.BidRequest.Imp.Native.Image.ImageAssetType.MAIN);
            image.setW(commonSizeInfo.getWidth());
            image.setH(commonSizeInfo.getHeight());
            nativeAd.addImgs(image);
        }
        if (commonSizeInfo.getType() == 3) {
            IqiyiBid.BidRequest.Imp.Native.Video.Builder video = IqiyiBid.BidRequest.Imp.Native.Video.newBuilder();
            video.setW(commonSizeInfo.getWidth());
            video.setH(commonSizeInfo.getHeight());
            if (commonSizeInfo.getMinduration() != null) {
                video.setMinduration(commonSizeInfo.getMinduration());
            } else {
                video.setMinduration(10);
            }
            if (commonSizeInfo.getMaxduration() != null) {
                video.setMaxduration(commonSizeInfo.getMaxduration());
            } else {
                video.setMaxduration(50);
            }

            video.setFormat(IqiyiBid.BidRequest.Imp.VideoFormat.VIDEO_MP4);
            nativeAd.setVideo(video);
        }
        nativeAd.setMaxadscount(1);

        return nativeAd.build();
    }

    private IqiyiBid.BidRequest.App appConvert(CommonAppInfo appInfo, DspInfo dspInfo) {
        IqiyiBid.BidRequest.App.Builder app = IqiyiBid.BidRequest.App.newBuilder();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
            app.setName(replaceApp.getName());
        } else {
            app.setBundle(appInfo.getBundle());
            if (StringUtils.isNotBlank(appInfo.getName())) {
                app.setName(appInfo.getName());
            }
        }

        if (StringUtils.isNotBlank(appInfo.getVersion())) {
            app.setVer(appInfo.getVersion());
        }

        return app.build();
    }

    private IqiyiBid.BidRequest.Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        if (commonDevice.getUa() == null) {
            return null;
        }
        IqiyiBid.BidRequest.Device.Builder device = IqiyiBid.BidRequest.Device.newBuilder();
        device.setUa(commonDevice.getUa());

        device.setIp(commonDevice.getIp());
        if (StringUtils.isNotEmpty(commonDevice.getIdFa())) {
            device.setIdfa(commonDevice.getIdFa());
        }
        if (StringUtils.isNotEmpty(commonDevice.getIdFaMd5())) {
            device.setIdfaMd5(commonDevice.getIdFaMd5());
        }
        if (StringUtils.isNotEmpty(commonDevice.getImeiMd5())) {
            device.setImeiMd5(commonDevice.getImeiMd5());
        }
        if (StringUtils.isNotEmpty(commonDevice.getDpId())) {
            device.setAndroidid(commonDevice.getDpId());
        }
        if (StringUtils.isNotEmpty(commonDevice.getDpIdMd5())) {
            device.setAndroididMd5(commonDevice.getDpIdMd5());
        }
        if (StringUtils.isNotEmpty(commonDevice.getOaId())) {
            device.setOaid(commonDevice.getOaId());
        }
        if (StringUtils.isNotEmpty(commonDevice.getOaIdMd5())) {
            device.setOaidMd5(commonDevice.getOaIdMd5());
        }
        if (StringUtils.isNotEmpty(commonDevice.getMac())) {
            device.setMac(commonDevice.getMac());
        }
        if (StringUtils.isNotEmpty(commonDevice.getMake())) {
            device.setMake(commonDevice.getMake());
        }
        if (StringUtils.isNotEmpty(commonDevice.getModel())) {
            device.setModel(commonDevice.getModel());
        }
        device.setOsv(commonDevice.getOsVersion());
        if ("1".equals(commonDevice.getOs())) {
            device.setOs("iOS");
        } else if ("0".equals(commonDevice.getOs())) {
            device.setOs("Android");
        } else {
            device.setOs("Android");
        }
        device.setDevicetype(IqiyiBid.BidRequest.Device.DeviceType.PHONE);

        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        } else if ("2".equals(carrier)) {
            device.setCarrier(2);
        } else if ("3".equals(carrier)) {
            device.setCarrier(3);
        } else {
            // 这里没有unknown的枚举值，就这么传吧
            device.setCarrier(4);
        }
        Integer connectionType = commonDevice.getTuiaConnectionType();
        if (connectionType == 2) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.WIFI);
        } else if (connectionType == 4) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_2G);
        } else if (connectionType == 5) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_3G);
        } else if (connectionType == 6) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_4G);
        } else if (connectionType == 7) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_5G);
        } else {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_UNKNOWN);
        }

        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            IqiyiBid.BidRequest.Device.CaidInfo.Builder caidList = IqiyiBid.BidRequest.Device.CaidInfo.newBuilder();
            for (Caid caid : commonDevice.getCaids()) {
                IqiyiBid.BidRequest.Device.Caid.Builder caidInfo = IqiyiBid.BidRequest.Device.Caid.newBuilder();
                caidInfo.setCaid(caid.getId());
                caidInfo.setVersion(caid.getVersion());
                caidList.addCaid(caidInfo);
            }
            device.setCaidInfo(caidList);
        }
        if (StringUtils.isNotBlank(commonDevice.getBootTime())) {
            device.setBootMark(commonDevice.getBootTime());
        }
        if (StringUtils.isNotBlank(commonDevice.getUpdateTime())) {
            device.setUpdateMark(commonDevice.getUpdateTime());
        }
        if (StringUtils.isNotBlank(commonDevice.getBirthTime())) {
            device.setFileInitTime(commonDevice.getBirthTime());
        }


        IqiyiBid.BidRequest.Geo geo = geoConvert(commonDevice.getGeo());
        device.setGeo(geo);

        return device.build();
    }

    private IqiyiBid.BidRequest.Geo geoConvert(CommonGeo commonGeo) {
        IqiyiBid.BidRequest.Geo.Builder geo = IqiyiBid.BidRequest.Geo.newBuilder();
        if (commonGeo != null) {
            if (commonGeo.getLat() != null && commonGeo.getLon() != null) {
                geo.setLat(commonGeo.getLat().floatValue());
                geo.setLon(commonGeo.getLon().floatValue());
                // 假设位置来源为 IP 地址
                geo.setType(IqiyiBid.BidRequest.Geo.LocationType.IP);
            }
//            geo.setCountry(commonGeo.getCountry());
//            geo.setProv(commonGeo.getProv());
//            geo.setCity(commonGeo.getCity());
//            geo.setDistrict(commonGeo.getDistrict());
        }
        return geo.build();
    }

}
