package cn.com.duiba.tuia.dsp.engine.api.dsp.youku;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert.RequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert.RespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

@Slf4j
@Component
public class YouKuDspInvoker extends AbstractDspCaller<BidResponse, BidRequest> {
    @Autowired
    private RequestConvert requestConvert;

    @Autowired
    private RespConvert respConvert;

    @Autowired
    private YouKuProperties youKuProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(youKuProperties.getUrl(), bidRequest), "invokeDSP", "youku");

        } catch (Throwable e) {
            Cat.logMetricForCount("优酷_竞价失败");
            log.warn("优酷调用失败,", e);
        }
        return null;
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<BidRequest> requestEntity = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<BidResponse> resEntity = null;
        Cat.logMetricForCount("优酷DSP请求");
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("优酷调用异常 response is {}", resEntity, e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        if (resEntity.getBody() == null || CollectionUtils.isEmpty(resEntity.getBody().getBid())) {
            return null;
        }
        Cat.logMetricForCount("优酷DSP返回");
        return resEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(youKuProperties.getSecret().getBytes(StandardCharsets.UTF_8), "AES"));
            byte[] result = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode( Base64.getUrlEncoder().encodeToString(result),"utf-8");
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException |
                 UnsupportedEncodingException |
                 BadPaddingException e) {
            log.warn("优酷价格加密失败,", e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_18.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_18;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotBlank(price)) {
            return url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return requestConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse != null && CollectionUtils.isNotEmpty(bidResponse.getBid())) {
            return respConvert.convert(bidResponse);
        }
        return null;
    }
}
