/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigDataUaUtils {
    private static final Logger log = LoggerFactory.getLogger(BigDataUaUtils.class);
    public static final String ANDROID = "android";
    public static final String IPHONE = "iphone";
    private static final String IPAD = "ipad";
    private static final String MAC = "mac";
    private static final String MAC_OS = "mac os";
    private static final String MACOS = "macos";
    private static final String HARMONYOS = "harmonyos";
    private static final String LIKE = "like";
    private static final String IOS = "ios";
    private static final String MACINTOSH = "macintosh";
    private static final Pattern pattern = Pattern.compile("^[a-z0-9_\\-\\.]*$");

    public static UserAgentDto parseUserAgent(String ua) {
        try {
            String model;
            String[] array;
            if (StringUtils.isBlank((CharSequence)ua)) {
                return null;
            }
            if (ua.contains("Mozilla%2F")) {
                ua = ua.substring(0, ua.lastIndexOf("%"));
                ua = URLDecoder.decode(ua, StandardCharsets.UTF_8.name());
            }
            if (!(ua = ua.toLowerCase()).contains("(") || !ua.contains(")")) {
                return null;
            }
            String coreUa = "";
            for (String tmp : array = StringUtils.split((String)ua, (String)"(")) {
                if (tmp.contains("mozilla") || tmp.contains("mozila") || tmp.contains("zzcios") || !tmp.contains(ANDROID) && !tmp.contains(IPHONE) && !tmp.contains(IPAD) && !tmp.contains(MAC_OS)) continue;
                coreUa = StringUtils.split((String)tmp, (String)")")[0];
                break;
            }
            if (StringUtils.isBlank((CharSequence)coreUa)) {
                return null;
            }
            if (coreUa.contains(IPHONE) && coreUa.contains(MAC_OS)) {
                return BigDataUaUtils.getIphoneList(coreUa, IPHONE);
            }
            if (coreUa.contains(IPAD) && coreUa.contains(MAC_OS)) {
                return BigDataUaUtils.getIphoneList(coreUa, IPAD);
            }
            if (coreUa.contains(MACINTOSH) && coreUa.contains(MAC_OS)) {
                return BigDataUaUtils.getMacList(coreUa, MAC);
            }
            if (coreUa.contains(HARMONYOS)) {
                model = BigDataUaUtils.getHarmonyModel(coreUa);
                if (StringUtils.isNotBlank((CharSequence)model)) {
                    return BigDataUaUtils.getHarmonyOSList(coreUa, model);
                }
            } else if (coreUa.contains(ANDROID) && StringUtils.isNotBlank((CharSequence)(model = BigDataUaUtils.getAndroidModel(coreUa)))) {
                coreUa = StringUtils.replace((String)coreUa, (String)"zh-cn", (String)"");
                return BigDataUaUtils.getAndroidList(coreUa, model);
            }
        }
        catch (Exception e) {
            log.error("UserAgentUtil parseUserAgent error, ua = {}", (Object)ua, (Object)e);
        }
        return null;
    }

    private static String check(String osVersion) {
        if (StringUtils.isBlank((CharSequence)osVersion)) {
            return null;
        }
        return pattern.matcher(osVersion).matches() ? osVersion.replaceAll("_", ".") : null;
    }

    private static String checkModel(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return null;
        }
        if (StringUtils.split((String)model, (String)"/").length > 1) {
            model = StringUtils.split((String)model, (String)"/")[0];
        }
        if (model.contains(".")) {
            return null;
        }
        return model.contains(ANDROID) ? null : model;
    }

    private static String getHarmonyModel(String coreUa) {
        String[] data = StringUtils.split((String)coreUa, (String)";");
        for (int i = 0; i < data.length; ++i) {
            if (!HARMONYOS.equals(data[i].trim()) || i + 1 >= data.length) continue;
            return data[i + 1].trim();
        }
        return null;
    }

    private static String getAndroidModel(String tmpCoreUa) {
        String coreUa = StringUtils.replace((String)tmpCoreUa, (String)"zh-cn;", (String)"");
        if (coreUa.contains("build")) {
            String[] split;
            coreUa = StringUtils.replace((String)coreUa, (String)"; build", (String)" build");
            for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
                if (!data.contains("build")) continue;
                return BigDataUaUtils.checkModel(data.substring(0, data.indexOf("build")).trim());
            }
        } else if (coreUa.contains("bulid")) {
            String[] split;
            for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
                if (!data.contains("bulid")) continue;
                return BigDataUaUtils.checkModel(data.substring(0, data.indexOf("bulid")).trim());
            }
        } else if (coreUa.contains("miui/")) {
            String[] split;
            for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
                if (!data.contains("miui/")) continue;
                return BigDataUaUtils.checkModel(data.substring(0, data.indexOf("miui/")).trim());
            }
        } else {
            String[] data = StringUtils.split((String)coreUa, (String)";");
            for (int i = 0; i < data.length; ++i) {
                if (!data[i].contains(ANDROID) || i + 1 >= data.length) continue;
                return BigDataUaUtils.checkModel(data[i + 1].trim());
            }
        }
        return null;
    }

    private static UserAgentDto getIphoneList(String coreUa, String model) {
        String[] split;
        String osVersion = "";
        for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
            if (!data.contains(MAC_OS) || !data.contains(LIKE)) continue;
            osVersion = data.substring(data.indexOf("os") + 2, data.indexOf(LIKE)).trim();
            break;
        }
        UserAgentDto dto = new UserAgentDto();
        dto.setPhoneModel(model);
        dto.setOs(IOS);
        dto.setOsVersion(BigDataUaUtils.check(osVersion));
        return dto;
    }

    private static UserAgentDto getMacList(String coreUa, String model) {
        String[] split;
        String osVersion = "";
        for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
            if (!data.contains(MAC_OS)) continue;
            osVersion = data.substring(data.indexOf("mac os x") + 8).trim();
            break;
        }
        if (osVersion.contains("rv:")) {
            osVersion = osVersion.substring(0, osVersion.indexOf("rv:")).trim();
        }
        if (osVersion.contains(" ")) {
            osVersion = StringUtils.replace((String)osVersion, (String)" ", (String)"_");
        }
        UserAgentDto dto = new UserAgentDto();
        dto.setPhoneModel(model);
        dto.setOs(MACOS);
        dto.setOsVersion(BigDataUaUtils.check(osVersion));
        return dto;
    }

    private static UserAgentDto getHarmonyOSList(String coreUa, String model) {
        String[] split;
        String osVersion = "";
        for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
            if (!data.contains(HARMONYOS)) continue;
            osVersion = StringUtils.replace((String)data, (String)HARMONYOS, (String)"").trim();
            break;
        }
        UserAgentDto dto = new UserAgentDto();
        dto.setPhoneModel(model);
        dto.setOs(HARMONYOS);
        dto.setOsVersion(BigDataUaUtils.check(osVersion));
        return dto;
    }

    private static UserAgentDto getAndroidList(String coreUa, String model) {
        String[] split;
        String osVersion = "";
        for (String data : split = StringUtils.split((String)coreUa, (String)";")) {
            if (!data.contains(ANDROID)) continue;
            osVersion = StringUtils.replace((String)data, (String)ANDROID, (String)"").trim();
            break;
        }
        UserAgentDto dto = new UserAgentDto();
        dto.setPhoneModel(model);
        dto.setOs(ANDROID);
        dto.setOsVersion(BigDataUaUtils.check(osVersion));
        return dto;
    }

    public static class UserAgentDto {
        private String phoneModel;
        private String os;
        private String osVersion;

        public String getPhoneModel() {
            return this.phoneModel;
        }

        public String getOs() {
            return this.os;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public void setPhoneModel(String phoneModel) {
            this.phoneModel = phoneModel;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }
    }
}

