/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Adm;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.SeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FancyRespConvert {
    public AdxCommonBidResponse convert(BidResponse bidResponse) {
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(bidResponse.getId());
        commonBidResponse.setDspId(DspEnum.DSP_17.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatBidConvert(bidResponse.getSeatbid());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<SeatBid> seatbid) {
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        SeatBid seatBid = seatbid.get(0);
        List<Bid> bidList = seatBid.getBid();
        Bid bid = bidList.get(0);
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        ArrayList<String> nurls = new ArrayList<String>();
        nurls.add(bid.getNurl());
        commonSeatBid.setWinCallbackUrls(nurls);
        commonSeatBid.setExposureCallbackUrls(bid.getImp_trackers());
        commonSeatBid.setClickCallbackUrls(bid.getClick_trackers());
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank((CharSequence)adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.getExt() != null && StringUtils.isNotBlank((CharSequence)adm.getExt().getIcon())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getExt().getIcon());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (adm.getVideo() != null) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            CommonVideo commonVideo = new CommonVideo();
            Video video = adm.getVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getW());
            commonVideo.setResolutionY(video.getH());
            if (CollectionUtils.isNotEmpty(adm.getImg())) {
                Image image2 = adm.getImg().get(0);
                commonVideo.setCoverUrl(image2.getUrl());
                commonVideo.setCoverHeight(image2.getH());
                commonVideo.setCoverWidth(image2.getW());
            }
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else if (CollectionUtils.isNotEmpty(adm.getImg())) {
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            for (Image image3 : adm.getImg()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image3.getUrl());
                commonImage.setHeight(image3.getH());
                commonImage.setWidth(image3.getW());
                commonImageList.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImageList);
        }
        commonCreative.setLandingPageUrl(adm.getLand());
        commonCreative.setDeepLinkUrl(adm.getDplink());
        if (adm.getApp() != null) {
            commonCreative.setAppName(adm.getApp().getName());
            commonCreative.setAppBundle(adm.getApp().getPackage_name());
        }
        commonSeatBidList.add(commonSeatBid);
        return commonSeatBidList;
    }
}

