/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.proto.BaiDuDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BaiDuDspRespConvert {
    public AdxCommonBidResponse convert(BaiDuDsp.Response response) {
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(response.getReqId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_27.getDspId());
        List<CommonSeatBid> commonSeatBidList = this.seatBidConvert(response.getSeatbidList());
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<BaiDuDsp.Seatbid> seatbidList) {
        String[] split;
        BaiDuDsp.Seatbid seatbid = seatbidList.get(0);
        BaiDuDsp.Seatbid.Bid bid = seatbid.getBid();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        CommonContext commonContext = new CommonContext();
        commonSeatBid.setCommonContext(commonContext);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        int bidPrice = bid.getBidPrice();
        commonSeatBid.setPrice((double)bidPrice * 1.0);
        commonCreative.setMaterialId(bid.getCrid());
        int bidMod = bid.getBidMod();
        if (2 == bidMod) {
            commonSeatBid.setPriceType(1);
        }
        commonSeatBid.setExposureCallbackUrls((List<String>)bid.getImpTrackingUrlList());
        commonSeatBid.setClickCallbackUrls((List<String>)bid.getClickTrackingUrlList());
        commonSeatBid.setWinCallbackUrls((List<String>)bid.getWinNoticeUrlList());
        BaiDuDsp.Seatbid.Bid.Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank((CharSequence)bid.getDeepLink())) {
            commonCreative.setDeepLinkUrl(bid.getDeepLink());
            commonContext.setDeepLinkUrl(bid.getDeepLink());
        }
        if (StringUtils.isNotBlank((CharSequence)bid.getUniversalLink())) {
            commonCreative.setULinkUrl(bid.getUniversalLink());
            commonContext.setULinkUrl(bid.getUniversalLink());
        }
        commonCreative.setDeveloper(bid.getDeveloper());
        commonCreative.setAppBundle(bid.getPackageName());
        commonCreative.setAppName(bid.getAppName());
        commonCreative.setLandingPageUrl(bid.getLandingUrl());
        String templateId = bid.getTemplateId();
        Integer width = 0;
        Integer height = 0;
        if (StringUtils.isNotBlank((CharSequence)templateId) && (split = templateId.split("x")).length == 2) {
            width = Integer.parseInt(split[0].substring(3));
            height = Integer.parseInt(split[1]);
        }
        if (StringUtils.isNotBlank((CharSequence)templateId) && templateId.startsWith("IMG")) {
            String img = adm.getImg();
            CommonImage commonImage = new CommonImage();
            commonImage.setWidth(width);
            commonImage.setHeight(height);
            commonImage.setUrl(img);
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            commonImageList.add(commonImage);
            commonCreative.setCommonImageList(commonImageList);
        }
        if (StringUtils.isNotBlank((CharSequence)templateId) && templateId.startsWith("VID")) {
            String videoUrl = adm.getVideoUrl();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setResolutionX(width);
            commonVideo.setResolutionY(height);
            commonVideo.setCoverUrl(adm.getCoverUrl());
            String videoDuration = adm.getVideoDuration();
            if (StringUtils.isNotBlank((CharSequence)videoDuration)) {
                commonVideo.setDuration(new BigDecimal(videoDuration));
            }
            commonVideo.setCoverWidth(width);
            commonVideo.setCoverHeight(height);
            commonVideo.setVideoUrl(videoUrl);
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDescText())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDescText());
            commonCreative.setCommonDesc(commonDesc);
        }
        commonCreative.setBrandName(adm.getDisplayName());
        if (StringUtils.isNotBlank((CharSequence)adm.getAvatarUrl())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getAvatarUrl());
            commonCreative.setCommonIcon(commonIcon);
            commonCreative.setIconUrl(adm.getAvatarUrl());
        }
        return commonSeatBidList;
    }

    public static void main(String[] args) {
        String img1080x1920 = "IMG1080x1920";
        String[] split = img1080x1920.split("x");
        System.out.println(split[0].substring(3));
        System.out.println(split[1]);
    }
}

