/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.GuangtuiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.bean.Guangtui;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter.GuangtuiResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter.GunagtuiRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class GuangtuiDspInvoker
extends AbstractDspCaller<Guangtui.Response, Guangtui.Request> {
    private static final Logger log = LoggerFactory.getLogger(GuangtuiDspInvoker.class);
    @Resource
    private GunagtuiRequestConverter guangtuiRequestConverter;
    @Resource
    private GuangtuiResponseConverter guangtuiResponseConverter;
    @Resource
    private GuangtuiProperties guangtuiProperties;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected Guangtui.Response invokeDsp(Guangtui.Request rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u5e7f\u63a8DSP\u8c03\u7528");
        try {
            return (Guangtui.Response)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.guangtuiProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"guangtui");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u5e7f\u63a8_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u5e7f\u63a8\u7ade\u4ef7\u5931\u8d25", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private Guangtui.Response doHttpInvoke(String url, Guangtui.Request rtbRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf");
        HttpEntity requestEntity = new HttpEntity((Object)rtbRequest.toByteArray(), (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        Guangtui.Response body = Guangtui.Response.parseFrom(resource.getInputStream());
        if (body.getCode() == 0) {
            Cat.logMetricForCount((String)"\u5e7f\u63a8DSP\u8fd4\u56de");
            return body;
        }
        SamplerLog.info((String)"\u5e7f\u63a8dsp \u8fd4\u56de {}", (Object[])new Object[]{JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)body)});
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] keyBytes = this.guangtuiProperties.getSecret().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[16];
            System.arraycopy(keyBytes, 0, iv, 0, 16);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            log.warn("GunagtuiDspInvoker \u4ef7\u683c\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_22.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_22;
    }

    @Override
    public Guangtui.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.guangtuiRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(Guangtui.Response rtbResponse) throws DspException {
        try {
            return this.guangtuiResponseConverter.respConvert(rtbResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        String defaultCoordinate = "-999";
        if (url.contains("_PRICE_") && price != null) {
            url = url.replace("_PRICE_", price);
        }
        if (url.contains("_WIDTH_")) {
            url = url.replace("_WIDTH_", "500");
        }
        if (url.contains("_HEIGHT_")) {
            url = url.replace("_HEIGHT_", "500");
        }
        if (url.contains("_SBZMX_")) {
            url = url.replace("_SBZMX_", defaultCoordinate);
        }
        if (url.contains("_SBZMY_")) {
            url = url.replace("_SBZMY_", defaultCoordinate);
        }
        if (url.contains("_SBZCX_")) {
            url = url.replace("_SBZCX_", defaultCoordinate);
        }
        if (url.contains("_SBZCY_")) {
            url = url.replace("_SBZCY_", defaultCoordinate);
        }
        if (url.contains("_ABZMX_")) {
            url = url.replace("_ABZMX_", defaultCoordinate);
        }
        if (url.contains("_ABZMY_")) {
            url = url.replace("_ABZMY_", defaultCoordinate);
        }
        if (url.contains("_ABZCX_")) {
            url = url.replace("_ABZCX_", defaultCoordinate);
        }
        if (url.contains("_ABZCY_")) {
            url = url.replace("_ABZCY_", defaultCoordinate);
        }
        if (url.contains("_DPLINK_")) {
            url = url.replace("_DPLINK_", "1");
        }
        if (url.contains("_ORIGINTIME_")) {
            url = url.replace("_ORIGINTIME_", String.valueOf(System.currentTimeMillis()));
        }
        if (url.contains("_ORIGIN_TIME_S_")) {
            long unixTimestamp = System.currentTimeMillis() / 1000L;
            url = url.replace("_ORIGIN_TIME_S_", String.valueOf(unixTimestamp));
        }
        return url;
    }
}

