package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCallbackRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter.JinghongRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter.JinghongResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.List;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.REQ_PARAM_CONVERT_ERROR;
import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.RESP_PARAM_CONVERT_ERROR;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class JinghongDspInvoker extends AbstractDspCaller<Jinghong.AdResponse, Jinghong.AdRequest> {

    @Resource
    private JinghongRequestConverter jinghongRequestConverter;

    @Resource
    private JinghongResponseConverter jinghongResponseConverter;

    @Resource
    private JinghongProperties jinghongProperties;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected Jinghong.AdResponse invokeDsp(Jinghong.AdRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount("鲸鸿动能DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(jinghongProperties.getUrl(), rtbRequest), "invokeDSP", "jinghong");
        } catch (Throwable t) {
            Cat.logMetricForCount("鲸鸿动能_竞价失败");
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("鲸鸿动能竞价失败", t);
            }
            return null;
        }
    }

    private Jinghong.AdResponse doHttpInvoke(String url, Jinghong.AdRequest rtbRequest) {

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String authHeader = DigestAuthUtil.getPostReqDigestHeader("/ppsadx/getResult", jinghongProperties.getKey(), jinghongProperties.getPublisherId(), jinghongProperties.getKeyId());
        headers.add("Authorization", authHeader);
        HttpEntity<Jinghong.AdRequest> entity = new HttpEntity<>(rtbRequest, headers);
        Jinghong.AdResponse response = restTemplate.postForObject(url, entity, Jinghong.AdResponse.class);
        if (response == null) {
            return null;
        }
        if (Integer.valueOf(200).equals(response.getRetcode())) {
            Cat.logMetricForCount("鲸鸿动能DSP返回");
            return response;
        } else {
            SamplerLog.info("鲸鸿动能dsp 返回 {}", JSON.toJSONString(response));
            return null;
        }
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        return String.valueOf(price);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_24.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_24;
    }

    @Override
    public Jinghong.AdRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return jinghongRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(Jinghong.AdResponse rtbResponse) throws DspException {
        try {
            return jinghongResponseConverter.respConvert(rtbResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url;
    }


    @Override
    protected void replaceReturnMacro(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo, AdxCommonBidResponse commonBidResponse) {
        CommonSeatBid commonSeatBid = commonBidResponse.getCommonSeatBidList().get(0);
        List<String> exposureCallbackUrls = commonSeatBid.getExposureCallbackUrls();
        CommonImp commonImp = commonBidRequest.getImpList().get(0);
        Integer w = commonImp.getW();
        Integer h = commonImp.getH();
        for (int i = 0; i < exposureCallbackUrls.size(); i++) {
            String url = exposureCallbackUrls.get(i);
            if (w != null && h != null) {
                url = url.replace("__HW_W__", String.valueOf(w)).replace("__HW_H__", String.valueOf(h));
            }
            exposureCallbackUrls.set(i, url);
        }
        List<String> clickCallbackUrls = commonSeatBid.getClickCallbackUrls();
        CommonDevice commonDevice = commonBidRequest.getDevice();
        int ppi = commonDevice.getPpi();
        for (int i = 0; i < clickCallbackUrls.size(); i++) {
            String url = clickCallbackUrls.get(i);
            if (w != null && h != null) {
                url = url.replace("__HW_W__", String.valueOf(w)).replace("__HW_H__", String.valueOf(h));
            }
            if (ppi != 0) {
                url = url.replace("__HW_DENSITY__", String.valueOf(ppi));
            }
            clickCallbackUrls.set(i, url);

        }

    }

    @Override
    public String replaceEventMacro(String url, CommonCallbackRequest callbackRequest) {
        if (callbackRequest == null) {
            return url;
        }
        if (callbackRequest.getTimeStamp() == 0) {
            return url;
        }
        Integer type = callbackRequest.getType();
        if (type == 0) {
            return url.replace("__HW_EVENT_TIME__ ", String.valueOf(callbackRequest.getTimeStamp()));
        }
        if (callbackRequest.getAdW() != 0 && callbackRequest.getAdH() != 0) {
            url = url.replace("__HW_W__", String.valueOf(callbackRequest.getAdW()));
            url = url.replace("__HW_H__", String.valueOf(callbackRequest.getAdH()));
        }
        if (callbackRequest.getDpi() != 0) {
            url = url.replace("__HW_DENSITY__", String.valueOf(callbackRequest.getDpi()));
        }
        int activeSlide = callbackRequest.getActiveSlide();
        if (activeSlide == 0 || activeSlide == 1 || activeSlide == 6) {
            if (callbackRequest.getAdClickDownX() == 0 && callbackRequest.getAdClickDownY() == 0) {
                callbackRequest.setAdClickDownX(-999);
                callbackRequest.setAdClickDownY(-999);
            }
            if (callbackRequest.getAdClickUpX() == 0 && callbackRequest.getAdClickUpY() == 0) {
                callbackRequest.setAdClickUpX(-999);
                callbackRequest.setAdClickUpY(-999);
            }
            url = url.replace("__HW_DOWN_X__", String.valueOf(callbackRequest.getAdClickDownX()))
                    .replace("__HW_DOWN_Y__", String.valueOf(callbackRequest.getAdClickDownY()))
                    .replace("__HW_UP_X__", String.valueOf(callbackRequest.getAdClickUpX()))
                    .replace("__HW_UP_Y__", String.valueOf(callbackRequest.getAdClickUpY()));
        }
        if (activeSlide == 2) {
            url = url.replace("__HW_X_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelX()))
                    .replace("__HW_Y_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelY()))
                    .replace("__HW_Z_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelZ()));
        }
        url = url.replace("__HW_SLD__", String.valueOf(activeSlide))
                .replace("__HW_DOWN_TIME__", String.valueOf(callbackRequest.getTimeStamp()));

        return url;
    }
}
