package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author yuquanfeng
 * @Date 2022/11/28
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class AdvertConditionFilterHolder {
    @Autowired
    private List<AdvertConditionFilter> advertConditionFilters;

    public List<DspInfo> filter(List<DspInfo> dspInfos){
        List<DspInfo> result = null;
        if(CollectionUtils.isEmpty(dspInfos)){
            return null;
        }
        try {
            result = dspInfos.stream().filter(this::match).collect(Collectors.toList());
        }catch (Exception e){
            log.error("AdvertConditionFilterHolder.filter error", e);
        }
        return result;
    }

    public boolean match(DspInfo dspInfo){
        return advertConditionFilters.stream().allMatch(advertConditionFilter -> {
            try {
                return advertConditionFilter.match(dspInfo);
            }catch (Exception e){
                log.warn("AdvertConditionFilterHolder 过滤发生异常", e);
                return false;
            }
        });
    }
}
