/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.youku;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.YouKuProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert.RequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert.RespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class YouKuDspInvoker
extends AbstractDspCaller<BidResponse, BidRequest> {
    private static final Logger log = LoggerFactory.getLogger(YouKuDspInvoker.class);
    @Autowired
    private RequestConvert requestConvert;
    @Autowired
    private RespConvert respConvert;
    @Autowired
    private YouKuProperties youKuProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        try {
            return (BidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.youKuProperties.getUrl(), bidRequest), (String)"invokeDSP", (String)"youku");
        }
        catch (Throwable e) {
            Cat.logMetricForCount((String)"\u4f18\u9177_\u7ade\u4ef7\u5931\u8d25");
            log.warn("\u4f18\u9177\u8c03\u7528\u5931\u8d25,", e);
            return null;
        }
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        ResponseEntity resEntity;
        block4: {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            headers.add("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)bidRequest, (MultiValueMap)headers);
            resEntity = null;
            Cat.logMetricForCount((String)"\u4f18\u9177DSP\u8bf7\u6c42");
            try {
                resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof RestClientException) break block4;
                log.warn("\u4f18\u9177\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        if (resEntity.getBody() == null || CollectionUtils.isEmpty(((BidResponse)resEntity.getBody()).getBid())) {
            return null;
        }
        Cat.logMetricForCount((String)"\u4f18\u9177DSP\u8fd4\u56de");
        return (BidResponse)resEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(this.youKuProperties.getSecret().getBytes(StandardCharsets.UTF_8), "AES"));
            byte[] result = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode(Base64.getUrlEncoder().encodeToString(result), "utf-8");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.warn("\u4f18\u9177\u4ef7\u683c\u52a0\u5bc6\u5931\u8d25,", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_18.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_18;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotBlank((CharSequence)price)) {
            return url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.requestConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse != null && CollectionUtils.isNotEmpty(bidResponse.getBid())) {
            return this.respConvert.convert(bidResponse);
        }
        return null;
    }
}

