/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.bean.TgSsp;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TianGongRespConvert {
    public AdxCommonBidResponse convert(TgSsp.Response response) {
        TgSsp.Response.Ad ad = response.getAd();
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(response.getImpressionId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_20.getDspId());
        List<CommonSeatBid> commonSeatBidList = this.seatBidConvert(ad);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(TgSsp.Response.Ad ad) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        CommonCreative commonCreative = new CommonCreative();
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        if (StringUtils.isNotBlank((CharSequence)ad.getTitle())) {
            CommonTitle title = new CommonTitle();
            title.setTitle(ad.getTitle());
            commonCreative.setCommonTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)ad.getSubTitle())) {
            CommonDesc desc = new CommonDesc();
            desc.setDesc(ad.getSubTitle());
            commonCreative.setCommonDesc(desc);
        }
        if (StringUtils.isNotBlank((CharSequence)ad.getSourceAvatar())) {
            CommonIcon icon = new CommonIcon();
            icon.setUrl(ad.getSourceAvatar());
            commonCreative.setCommonIcon(icon);
            commonCreative.setIconUrl(ad.getSourceAvatar());
        }
        String creativeDomain = ad.getCreativeDomain();
        List<TgSsp.Response.Ad.Creative> creativeList = ad.getCreativeList();
        TgSsp.Response.Ad.Creative creative = creativeList.get(0);
        String creativeUrl = creative.getCreativeUrl();
        String url = creativeDomain + creativeUrl;
        CommonImage image2 = new CommonImage();
        image2.setUrl(url);
        ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
        commonImageList.add(image2);
        commonCreative.setCommonImageList(commonImageList);
        if (StringUtils.isNotBlank((CharSequence)ad.getJdClickUrl())) {
            if (StringUtils.isNotBlank((CharSequence)ad.getJdOpenUrl())) {
                commonCreative.setDeepLinkUrl(ad.getJdOpenUrl());
                context.setDeepLinkUrl(ad.getJdOpenUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)ad.getJdULinkUrl())) {
                commonCreative.setULinkUrl(ad.getJdULinkUrl());
                context.setULinkUrl(ad.getJdULinkUrl());
            }
            commonCreative.setLandingPageUrl(ad.getJdClickUrl());
            String jdImpUrl = ad.getJdImpUrl();
            ArrayList<String> exposureUrls = new ArrayList<String>();
            exposureUrls.add(jdImpUrl);
            if (StringUtils.isNotBlank((CharSequence)ad.getThirdImpUrl())) {
                exposureUrls.add(ad.getThirdImpUrl());
            }
            commonSeatBid.setExposureCallbackUrls(exposureUrls);
            ArrayList<String> clickUrls = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)ad.getThirdClickUrl())) {
                clickUrls.add(ad.getThirdClickUrl());
            }
            if (CollectionUtils.isNotEmpty((Collection)ad.getExtendClickUrlsList())) {
                clickUrls.addAll((Collection<String>)ad.getExtendClickUrlsList());
            }
            if (CollectionUtils.isNotEmpty(clickUrls)) {
                commonSeatBid.setClickCallbackUrls(clickUrls);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)ad.getOpenUrl())) {
                commonCreative.setDeepLinkUrl(ad.getOpenUrl());
                context.setDeepLinkUrl(ad.getOpenUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)ad.getULinkUrl())) {
                commonCreative.setULinkUrl(ad.getULinkUrl());
                context.setULinkUrl(ad.getULinkUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)ad.getClickUrl())) {
                commonCreative.setLandingPageUrl(ad.getClickUrl());
            }
            ArrayList<String> exposureUrls = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)ad.getImpressionUrl())) {
                exposureUrls.add(ad.getImpressionUrl());
            }
            commonSeatBid.setExposureCallbackUrls(exposureUrls);
            ArrayList<String> clickUrls = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)ad.getExtendClickUrlsList())) {
                clickUrls.addAll((Collection<String>)ad.getExtendClickUrlsList());
            }
            commonSeatBid.setClickCallbackUrls(clickUrls);
        }
        commonSeatBid.setCommonCreative(commonCreative);
        commonSeatBidList.add(commonSeatBid);
        return commonSeatBidList;
    }
}

