/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.bean.TgSsp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TianGongReqConvert {
    public TgSsp.Request convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        TgSsp.Request.Builder request = TgSsp.Request.newBuilder();
        TgSsp.Request.Source.Builder source = TgSsp.Request.Source.newBuilder();
        source.setSourceId(dspInfo.getDspTagId());
        source.setImpressionId(adxCommonBidRequest.getRequestId());
        source.setIsMulti(false);
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        source.setWidth(commonSizeInfo.getWidth());
        source.setHeight(commonSizeInfo.getHeight());
        source.setIsFullscreen(false);
        request.setSource(source);
        TgSsp.Request.Device.Builder device = this.deviceConvert(adxCommonBidRequest, dspInfo);
        request.setDevice(device);
        return request.build();
    }

    private TgSsp.Request.Device.Builder deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        String carrier;
        Integer tuiaConnectionType;
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        TgSsp.Request.Device.Builder device = TgSsp.Request.Device.newBuilder();
        device.setIp(commonDevice.getIp());
        String os = commonDevice.getOs();
        if ("0".equals(os)) {
            device.setOs("Android");
            if (StringUtils.isNotBlank((CharSequence)commonDevice.getImeiMd5())) {
                device.setDeiviceId(commonDevice.getImeiMd5());
                device.setIdentifierType(TgSsp.IdentifierType.IMEI);
            } else if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaId())) {
                device.setDeiviceId(commonDevice.getOaId());
                device.setIdentifierType(TgSsp.IdentifierType.OAID);
            } else if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaIdMd5())) {
                device.setDeiviceId(commonDevice.getOaIdMd5());
                device.setIdentifierType(TgSsp.IdentifierType.OAID_MD5);
            }
        } else if ("1".equals(os)) {
            device.setOs("iOS");
            if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFaMd5())) {
                device.setDeiviceId(commonDevice.getIdFaMd5());
                device.setIdentifierType(TgSsp.IdentifierType.IDFA);
            }
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            device.setIdentifierType(TgSsp.IdentifierType.CAID);
            for (Caid caid : commonDevice.getCaids()) {
                TgSsp.Request.Device.CaidInfo.Builder caidInfo = TgSsp.Request.Device.CaidInfo.newBuilder();
                caidInfo.setCaid(caid.getId());
                caidInfo.setVersion(caid.getVersion());
                device.addCaidInfo(caidInfo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpId())) {
            device.setAndroidId(commonDevice.getDpId());
        }
        device.setDeviceType(0);
        if (commonDevice.getMake() != null) {
            device.setBrand(commonDevice.getMake());
        }
        if (commonDevice.getModel() != null) {
            device.setModel(commonDevice.getModel());
        }
        if (commonDevice.getOsVersion() != null) {
            device.setOsv(commonDevice.getOsVersion());
        }
        if ((tuiaConnectionType = commonDevice.getTuiaConnectionType()) != null) {
            if (tuiaConnectionType == 2) {
                device.setNetwork(1);
            } else if (tuiaConnectionType == 4) {
                device.setNetwork(2);
            } else if (tuiaConnectionType == 5) {
                device.setNetwork(3);
            } else if (tuiaConnectionType == 6) {
                device.setNetwork(4);
            } else if (tuiaConnectionType == 7) {
                device.setNetwork(5);
            } else {
                device.setNetwork(0);
            }
        }
        if ("1".equals(carrier = commonDevice.getCarrier())) {
            device.setOperator(1);
        } else if ("2".equals(carrier)) {
            device.setOperator(2);
        } else if ("3".equals(carrier)) {
            device.setOperator(3);
        } else {
            device.setOperator(0);
        }
        if (commonDevice.getGeo() != null) {
            TgSsp.Request.Device.Geo.Builder builder = TgSsp.Request.Device.Geo.newBuilder();
            builder.setLat(commonDevice.getGeo().getLat());
            builder.setLon(commonDevice.getGeo().getLon());
            device.setGeo(builder);
        }
        return device;
    }
}

