package cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.Imp;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class FancyReqConvert {
    @Autowired
    private AppReplace appReplace;


    public BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BidRequest bidRequest = new BidRequest();
        bidRequest.setId(adxCommonBidRequest.getRequestId());
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        List<Imp> imp = impConvert(impList, dspInfo);
        bidRequest.setImp(imp);
        App app = appConvert(adxCommonBidRequest, dspInfo);
        bidRequest.setApp(app);
        Device device = convertDevice(adxCommonBidRequest);
        bidRequest.setDevice(device);


        return bidRequest;
    }

    private Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        Device device = new Device();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        device.setImei(commonDevice.getImei());
        device.setImeimd5(commonDevice.getImeiMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaidmd5(commonDevice.getOaIdMd5());
        device.setAid(commonDevice.getDpId());
        device.setAidmd5(commonDevice.getDpIdMd5());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfamd5(commonDevice.getIdFaMd5());
        String os = commonDevice.getOs();
        if ("0".equals(os)) {
            device.setOs(2);
        } else if ("1".equals(os)) {
            device.setOs(1);
        } else {
            device.setOs(0);
        }
        device.setOsv(commonDevice.getOsVersion());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setDevicetype(1);
        device.setIp(commonDevice.getIp());
        device.setMac(commonDevice.getMac());
        device.setMacmd5(commonDevice.getMacMd5());
        device.setUa(commonDevice.getUa());
        //运营商 0：未知；1：移动；2：联通；3：电信
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        } else if ("2".equals(carrier)) {
            device.setCarrier(2);
        } else if ("3".equals(carrier)) {
            device.setCarrier(3);
        } else {
            device.setCarrier(0);
        }
        //网络类型 0：其他；1：WIFI；2：2G；3：3G；4：4G；5：5G
        Integer tuiaConnectionType = commonDevice.getTuiaConnectionType();
        device.setConnection_type(0);
        if (tuiaConnectionType != null) {
            if (tuiaConnectionType == 2) {
                device.setConnection_type(1);
            } else if (tuiaConnectionType == 4) {
                device.setConnection_type(2);
            } else if (tuiaConnectionType == 5) {
                device.setConnection_type(3);
            } else if (tuiaConnectionType == 6) {
                device.setConnection_type(4);
            } else if (tuiaConnectionType == 7) {
                device.setConnection_type(5);
            }
        }
        device.setBoot_mark(commonDevice.getBootTime());
        device.setUpdate_mark(commonDevice.getUpdateTime());
        device.setPaid(commonDevice.getPaid());
        device.setBoot_time(commonDevice.getBootTime());
        device.setUpdate_time(commonDevice.getUpdateTime());
        device.setBirth_time(commonDevice.getBirthTime());
        List<Caid> caids = commonDevice.getCaids();
        if (CollectionUtils.isNotEmpty(caids)) {
            List<String> caidInfos = new ArrayList<>();
            for (Caid caid : caids) {
                String caidInfo = caid.getVersion() + "_" + caid.getId();
                caidInfos.add(caidInfo);
            }
            device.setCaids(caidInfos);
        }


        return device;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
            app.setName(replaceApp.getName());
        } else {
            app.setBundle(appInfo.getBundle());
            app.setName(appInfo.getName());
        }
        return app;
    }

    private List<Imp> impConvert(List<CommonImp> impList, DspInfo dspInfo) {
        List<Imp> imps = new ArrayList<>();
        for (CommonImp commonImp : impList) {
            Imp imp = new Imp();
            imp.setId(commonImp.getId());
            imp.setSlotid(dspInfo.getDspTagId());
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            imp.setBidfloor(floorPrice);
            imp.setBidtype(0);
            imp.setSecure(1);
            imps.add(imp);
        }
        return imps;
    }
}
