/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceEncrypterUtils {
    private static final Integer InitializeVectorLength = 16;
    private static final Integer TokenLength = 32;
    private static final Integer SignatureLength = 4;
    private static final String ShaAlgo = "HmacSHA1";
    private static final Logger LOGGER = LoggerFactory.getLogger(PriceEncrypterUtils.class);

    private static String printHexBinary(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            stringBuilder.append(String.format("%02x", aByte));
        }
        return stringBuilder.toString();
    }

    private static String webSafeBase64Encode(byte[] plaintext_bytes) {
        byte[] ciphertext_bytes = Base64.encodeBase64((byte[])plaintext_bytes);
        Integer padding_count = 0;
        Integer len = ciphertext_bytes.length;
        while (padding_count < len && ciphertext_bytes[len - padding_count - 1] == 61) {
            padding_count = padding_count + 1;
        }
        if (padding_count > 0) {
            ciphertext_bytes = Arrays.copyOfRange(ciphertext_bytes, 0, len - padding_count);
            len = ciphertext_bytes.length;
        }
        for (int i = 0; i < len; ++i) {
            if (ciphertext_bytes[i] == 43) {
                ciphertext_bytes[i] = 45;
                continue;
            }
            if (ciphertext_bytes[i] != 47) continue;
            ciphertext_bytes[i] = 95;
        }
        return new String(ciphertext_bytes);
    }

    public static String encryptPrice(Integer price, byte[] initialize_vector, byte[] encryption_token, byte[] integrity_token) throws Exception {
        if (price == null || price < 0 || initialize_vector == null || initialize_vector.length < InitializeVectorLength || encryption_token == null || encryption_token.length != TokenLength || integrity_token == null || integrity_token.length != TokenLength) {
            throw new RuntimeException("params error");
        }
        byte[] initialize_bytes = Arrays.copyOfRange(initialize_vector, 0, (int)InitializeVectorLength);
        String price_str = price.toString();
        Mac HMAC = Mac.getInstance(ShaAlgo);
        HMAC.reset();
        HMAC.init(new SecretKeySpec(encryption_token, ShaAlgo));
        HMAC.update(initialize_bytes);
        byte[] pad = HMAC.doFinal();
        byte[] enc_price = price_str.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < enc_price.length; ++i) {
            int n = i;
            enc_price[n] = (byte)(enc_price[n] ^ pad[i % pad.length]);
        }
        HMAC.reset();
        HMAC.init(new SecretKeySpec(integrity_token, ShaAlgo));
        HMAC.update(price_str.getBytes(StandardCharsets.UTF_8));
        HMAC.update(initialize_bytes);
        byte[] signature_all = HMAC.doFinal();
        if (signature_all.length < SignatureLength) {
            throw new RuntimeException("internal error");
        }
        byte[] signature = Arrays.copyOfRange(signature_all, 0, (int)SignatureLength);
        int mallocLength = initialize_bytes.length + enc_price.length + signature.length;
        byte[] ciphertext_bytes = new byte[mallocLength];
        System.arraycopy(initialize_bytes, 0, ciphertext_bytes, 0, initialize_bytes.length);
        System.arraycopy(enc_price, 0, ciphertext_bytes, initialize_bytes.length, enc_price.length);
        System.arraycopy(signature, 0, ciphertext_bytes, initialize_bytes.length + enc_price.length, signature.length);
        return PriceEncrypterUtils.webSafeBase64Encode(ciphertext_bytes);
    }
}

