/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.bean.Guangtui;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class GuangtuiResponseConverter {
    public AdxCommonBidResponse respConvert(Guangtui.Response rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_22.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(Guangtui.Response rtbResponse) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        List<Guangtui.Bid> bidList = rtbResponse.getSeatbid().getBidList();
        if (CollectionUtils.isEmpty(bidList)) {
            return commonSeatBidList;
        }
        for (Guangtui.Bid slotAd : bidList) {
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            commonSeatBid.setAdvertiserId("44910");
            CommonCreative commonCreative = new CommonCreative();
            Guangtui.Adm adm = slotAd.getAdm();
            commonSeatBid.setPriceType(0);
            commonSeatBid.setPrice(Double.valueOf(slotAd.getPrice()));
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getIcon());
            commonCreative.setCommonIcon(commonIcon);
            commonCreative.setAppName(slotAd.getAppName());
            commonCreative.setAppBundle(slotAd.getPackageName());
            commonCreative.setDownloadUrl(slotAd.getDownloadUrl());
            commonCreative.setIconUrl(adm.getIcon());
            commonCreative.setDeepLinkUrl(slotAd.getTargetUrl());
            commonCreative.setULinkUrl(slotAd.getTargetUrl());
            commonCreative.setLandingPageUrl(slotAd.getLandingUrl());
            CommonContext context = new CommonContext();
            context.setULinkUrl(slotAd.getTargetUrl());
            commonSeatBid.setCommonContext(context);
            Guangtui.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setDuration(new BigDecimal(video.getDuration()));
            commonVideo.setSize(video.getFileSize());
            commonVideo.setCoverWidth(video.getW());
            commonVideo.setCoverHeight(video.getH());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
            if (adm.getImgCount() > 0) {
                ArrayList commonImageList = Lists.newArrayList();
                for (Guangtui.Image image2 : adm.getImgList()) {
                    CommonImage commonImage = new CommonImage();
                    commonImage.setUrl(image2.getUrl());
                    commonImage.setWidth(image2.getW());
                    commonImage.setHeight(image2.getH());
                    commonImageList.add(commonImage);
                }
                commonCreative.setCommonImageList(commonImageList);
            }
            Guangtui.Tracking tracking = slotAd.getTracking();
            commonSeatBid.setWinCallbackUrls((List<String>)tracking.getNoticeUrlsList());
            commonSeatBid.setExposureCallbackUrls((List<String>)tracking.getImpTrackersList());
            commonSeatBid.setClickCallbackUrls((List<String>)tracking.getClickTrackersList());
            commonSeatBid.setCommonCreative(commonCreative);
            commonSeatBidList.add(commonSeatBid);
        }
        return commonSeatBidList;
    }
}

