/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.filter.AdvertConditionFilter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdvertConditionFilterHolder {
    private static final Logger log = LoggerFactory.getLogger(AdvertConditionFilterHolder.class);
    @Autowired
    private List<AdvertConditionFilter> advertConditionFilters;

    public List<DspInfo> filter(List<DspInfo> dspInfos) {
        List result = null;
        if (CollectionUtils.isEmpty(dspInfos)) {
            return null;
        }
        try {
            result = dspInfos.stream().filter(this::match).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("AdvertConditionFilterHolder.filter error", (Throwable)e);
        }
        return result;
    }

    public boolean match(DspInfo dspInfo) {
        return this.advertConditionFilters.stream().allMatch(advertConditionFilter -> {
            try {
                return advertConditionFilter.match(dspInfo);
            }
            catch (Exception e) {
                log.warn("AdvertConditionFilterHolder \u8fc7\u6ee4\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                return false;
            }
        });
    }
}

