package cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.proto.AlipayDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.protobuf.ProtocolStringList;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.xb.substwsdl.TImport;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class AlipayDspRespConvert {

    public AdxCommonBidResponse convert(AlipayDsp.BidResponse bidResponse) {
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(bidResponse.getId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_25.getDspId());
        List<AlipayDsp.BidResponse.SeatBid> seatBidList = bidResponse.getSeatBidList();
        AlipayDsp.BidResponse.SeatBid seatBid = seatBidList.get(0);
        AlipayDsp.BidResponse.Bid bid = seatBid.getBidList().get(0);
        CommonSeatBid commonSeatBid = convert(bid);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        commonSeatBidList.add(commonSeatBid);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        adxCommonBidResponse.setUserScoreLevel(bid.getUserScoreLevel());
        return adxCommonBidResponse;
    }

    private CommonSeatBid convert(AlipayDsp.BidResponse.Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        CommonCreative commonCreative = new CommonCreative();

        commonSeatBid.setPrice((double) bid.getPrice());
        commonSeatBid.setPriceType(bid.getBidType());
        String creativeId = bid.getCreativeId();
        commonCreative.setCreativeId(creativeId);
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        ProtocolStringList impTrackersList = bid.getImpTrackersList();
        commonSeatBid.setExposureCallbackUrls(impTrackersList);
        ProtocolStringList clkTrackersList = bid.getClkTrackersList();
        commonSeatBid.setClickCallbackUrls(clkTrackersList);
        commonSeatBid.setCommonContext(context);
        commonSeatBid.setCommonCreative(commonCreative);
        commonCreative.setAppName(bid.getAppName());
        commonCreative.setAppBundle(bid.getPackageName());
        commonCreative.setIconUrl(bid.getIconUrl());

        AlipayDsp.BidResponse.Bid.Adm adm = bid.getAdm();
        String title = adm.getTitle();
        if (StringUtils.isNotBlank(title)) {
            CommonTitle commonTitle = new CommonTitle();
            if (title.contains("红包") || title.contains("支付")) {
                title = "快来这里看看吧!";
            }
            commonTitle.setTitle(title);
            commonCreative.setCommonTitle(commonTitle);
        }
        String desc = adm.getDesc();
        if (StringUtils.isNotBlank(desc)) {
            CommonDesc commonDesc = new CommonDesc();
            if (desc.contains("红包") || desc.contains("支付")) {
                desc = "快来这里看看吧!";
            }
            commonDesc.setDesc(desc);
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.hasVideo()) {
            AlipayDsp.BidResponse.Bid.Adm.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setCoverUrl(adm.getCoverImgUrl());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            List<CommonVideo> commonVideoList = new ArrayList<>();
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            List<AlipayDsp.BidResponse.Bid.Adm.Image> imageList = adm.getImageList();
            List<CommonImage> commonImageList = new ArrayList<>();
            for (AlipayDsp.BidResponse.Bid.Adm.Image image : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setWidth(image.getWidth());
                commonImage.setHeight(image.getHeight());
                commonImageList.add(commonImage);
                commonCreative.setCommonImageList(commonImageList);
            }
        }
        if (StringUtils.isNotBlank(adm.getDeepLink())) {
            commonCreative.setDeepLinkUrl(adm.getDeepLink());
            context.setDeepLinkUrl(adm.getDeepLink());
        }
        if (StringUtils.isNotBlank(adm.getUniversalLink())) {
            commonCreative.setULinkUrl(adm.getUniversalLink());
            context.setULinkUrl(adm.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(adm.getLandingSite());


        return commonSeatBid;
    }
}
