/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.proto.AlipayDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.protobuf.ProtocolStringList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AlipayDspRespConvert {
    public AdxCommonBidResponse convert(AlipayDsp.BidResponse bidResponse) {
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(bidResponse.getId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_25.getDspId());
        List<AlipayDsp.BidResponse.SeatBid> seatBidList = bidResponse.getSeatBidList();
        AlipayDsp.BidResponse.SeatBid seatBid = seatBidList.get(0);
        AlipayDsp.BidResponse.Bid bid = seatBid.getBidList().get(0);
        CommonSeatBid commonSeatBid = this.convert(bid);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        adxCommonBidResponse.setUserScoreLevel(bid.getUserScoreLevel());
        return adxCommonBidResponse;
    }

    private CommonSeatBid convert(AlipayDsp.BidResponse.Bid bid) {
        String desc;
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        commonSeatBid.setPriceType(bid.getBidType());
        String creativeId = bid.getCreativeId();
        commonCreative.setCreativeId(creativeId);
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        ProtocolStringList impTrackersList = bid.getImpTrackersList();
        commonSeatBid.setExposureCallbackUrls((List<String>)impTrackersList);
        ProtocolStringList clkTrackersList = bid.getClkTrackersList();
        commonSeatBid.setClickCallbackUrls((List<String>)clkTrackersList);
        commonSeatBid.setCommonContext(context);
        commonSeatBid.setCommonCreative(commonCreative);
        commonCreative.setAppName(bid.getAppName());
        commonCreative.setAppBundle(bid.getPackageName());
        if (StringUtils.isBlank((CharSequence)commonCreative.getAppBundle())) {
            commonCreative.setAppBundle("com.eg.android.AlipayGphone");
        }
        if (StringUtils.isBlank((CharSequence)commonCreative.getAppName())) {
            commonCreative.setAppName("\u652f\u4ed8\u5b9d");
        }
        commonCreative.setIconUrl(bid.getIconUrl());
        AlipayDsp.BidResponse.Bid.Adm adm = bid.getAdm();
        String title = adm.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            CommonTitle commonTitle = new CommonTitle();
            if (title.contains("\u7ea2\u5305") || title.contains("\u652f\u4ed8")) {
                title = "\u5feb\u6765\u8fd9\u91cc\u770b\u770b\u5427\uff01";
            }
            commonTitle.setTitle(title);
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(desc = adm.getDesc()))) {
            CommonDesc commonDesc = new CommonDesc();
            if (desc.contains("\u7ea2\u5305") || desc.contains("\u652f\u4ed8")) {
                desc = "\u5feb\u6765\u8fd9\u91cc\u770b\u770b\u5427\uff01";
            }
            commonDesc.setDesc(desc);
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.hasVideo()) {
            AlipayDsp.BidResponse.Bid.Adm.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setCoverUrl(adm.getCoverImgUrl());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            List<AlipayDsp.BidResponse.Bid.Adm.Image> imageList = adm.getImageList();
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            for (AlipayDsp.BidResponse.Bid.Adm.Image image2 : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getWidth());
                commonImage.setHeight(image2.getHeight());
                commonImageList.add(commonImage);
                commonCreative.setCommonImageList(commonImageList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDeepLink())) {
            commonCreative.setDeepLinkUrl(adm.getDeepLink());
            context.setDeepLinkUrl(adm.getDeepLink());
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getUniversalLink())) {
            commonCreative.setULinkUrl(adm.getUniversalLink());
            context.setULinkUrl(adm.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(adm.getLandingSite());
        return commonSeatBid;
    }
}

