/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleCache;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleManager;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.VsDestinationGroup;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboMatchRequest;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboRoute;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboRouteDetail;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceSpec;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.destination.DubboDestination;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.destination.DubboRouteDestination;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.StringMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.util.MeshRuleListener;
import org.apache.dubbo.rpc.cluster.router.mesh.util.TracingContextProvider;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public abstract class MeshRuleRouter<T>
extends AbstractStateRouter<T>
implements MeshRuleListener {
    public static final Logger logger = LoggerFactory.getLogger(MeshRuleRouter.class);
    private final Map<String, String> sourcesLabels;
    private volatile BitList<Invoker<T>> invokerList = BitList.emptyList();
    private volatile Set<String> remoteAppName = Collections.emptySet();
    protected MeshRuleManager meshRuleManager;
    protected Set<TracingContextProvider> tracingContextProviders;
    protected volatile MeshRuleCache<T> meshRuleCache = MeshRuleCache.emptyCache();

    public MeshRuleRouter(URL url) {
        super(url);
        this.sourcesLabels = Collections.unmodifiableMap(new HashMap(url.getParameters()));
        this.meshRuleManager = (MeshRuleManager)url.getOrDefaultModuleModel().getBeanFactory().getBean(MeshRuleManager.class);
        this.tracingContextProviders = url.getOrDefaultModuleModel().getExtensionLoader(TracingContextProvider.class).getSupportedExtensionInstances();
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        MeshRuleCache<T> ruleCache = this.meshRuleCache;
        if (!ruleCache.containsRule()) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"MeshRuleCache has not been built. Skip route.");
            }
            return invokers;
        }
        BitList<Invoker<T>> result = new BitList<Invoker<T>>(invokers.getOriginList(), true, invokers.getTailList());
        StringBuilder stringBuilder = needToPrintMessage ? new StringBuilder() : null;
        for (String appName : ruleCache.getAppList()) {
            String subset;
            List<DubboRouteDestination> routeDestination = this.getDubboRouteDestination(ruleCache.getVsDestinationGroup(appName), invocation);
            if (routeDestination == null || (subset = this.randomSelectDestination(ruleCache, appName, routeDestination, invokers)) == null) continue;
            BitList<Invoker<T>> destination = this.meshRuleCache.getSubsetInvokers(appName, subset);
            result = result.or(destination);
            if (stringBuilder == null) continue;
            stringBuilder.append("Match App: ").append(appName).append(" Subset: ").append(subset).append(" ");
        }
        if ((result = result.or(ruleCache.getUnmatchedInvokers())).isEmpty()) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Empty protection after routed.");
            }
            return invokers;
        }
        if (needToPrintMessage) {
            messageHolder.set((Object)stringBuilder.toString());
        }
        return invokers.and(result);
    }

    protected List<DubboRouteDestination> getDubboRouteDestination(VsDestinationGroup vsDestinationGroup, Invocation invocation) {
        List<VirtualServiceRule> virtualServiceRuleList;
        if (vsDestinationGroup != null && CollectionUtils.isNotEmpty(virtualServiceRuleList = vsDestinationGroup.getVirtualServiceRuleList())) {
            for (VirtualServiceRule virtualServiceRule : virtualServiceRuleList) {
                DubboRoute dubboRoute = this.getDubboRoute(virtualServiceRule, invocation);
                if (dubboRoute == null) continue;
                return this.getDubboRouteDestination(dubboRoute, invocation);
            }
        }
        return null;
    }

    protected DubboRoute getDubboRoute(VirtualServiceRule virtualServiceRule, Invocation invocation) {
        String serviceName = invocation.getServiceName();
        VirtualServiceSpec spec = virtualServiceRule.getSpec();
        List<DubboRoute> dubboRouteList = spec.getDubbo();
        if (CollectionUtils.isNotEmpty(dubboRouteList)) {
            for (DubboRoute dubboRoute : dubboRouteList) {
                List<StringMatch> stringMatchList = dubboRoute.getServices();
                if (CollectionUtils.isEmpty(stringMatchList)) {
                    return dubboRoute;
                }
                for (StringMatch stringMatch : stringMatchList) {
                    if (!stringMatch.isMatch(serviceName)) continue;
                    return dubboRoute;
                }
            }
        }
        return null;
    }

    protected List<DubboRouteDestination> getDubboRouteDestination(DubboRoute dubboRoute, Invocation invocation) {
        List<DubboRouteDetail> dubboRouteDetailList = dubboRoute.getRoutedetail();
        if (CollectionUtils.isNotEmpty(dubboRouteDetailList)) {
            for (DubboRouteDetail dubboRouteDetail : dubboRouteDetailList) {
                List<DubboMatchRequest> matchRequestList = dubboRouteDetail.getMatch();
                if (CollectionUtils.isEmpty(matchRequestList)) {
                    return dubboRouteDetail.getRoute();
                }
                if (!matchRequestList.stream().allMatch(request -> request.isMatch(invocation, this.sourcesLabels, this.tracingContextProviders))) continue;
                return dubboRouteDetail.getRoute();
            }
        }
        return null;
    }

    protected String randomSelectDestination(MeshRuleCache<T> meshRuleCache, String appName, List<DubboRouteDestination> routeDestination, BitList<Invoker<T>> availableInvokers) throws RpcException {
        String result;
        int totalWeight = 0;
        for (DubboRouteDestination dubboRouteDestination : routeDestination) {
            totalWeight += Math.max(dubboRouteDestination.getWeight(), 1);
        }
        int target = ThreadLocalRandom.current().nextInt(totalWeight);
        for (DubboRouteDestination destination : routeDestination) {
            if ((target -= Math.max(destination.getWeight(), 1)) > 0 || (result = this.computeDestination(meshRuleCache, appName, destination.getDestination(), availableInvokers)) == null) continue;
            return result;
        }
        for (DubboRouteDestination destination : routeDestination) {
            result = this.computeDestination(meshRuleCache, appName, destination.getDestination(), availableInvokers);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected String computeDestination(MeshRuleCache<T> meshRuleCache, String appName, DubboDestination dubboDestination, BitList<Invoker<T>> availableInvokers) throws RpcException {
        String subset = dubboDestination.getSubset();
        while (true) {
            BitList<Invoker<T>> result;
            if (CollectionUtils.isNotEmpty(result = meshRuleCache.getSubsetInvokers(appName, subset)) && !((BitList)availableInvokers.clone()).and(result).isEmpty()) {
                return subset;
            }
            DubboRouteDestination dubboRouteDestination = dubboDestination.getFallback();
            if (dubboRouteDestination == null || (dubboDestination = dubboRouteDestination.getDestination()) == null) break;
            subset = dubboDestination.getSubset();
        }
        return null;
    }

    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        BitList<Object> invokerList = invokers == null ? BitList.emptyList() : invokers;
        this.invokerList = invokerList.clone();
        this.registerAppRule(invokerList);
        this.computeSubset(this.meshRuleCache.getAppToVDGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAppRule(BitList<Invoker<T>> invokers) {
        HashSet<String> currentApplication = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(invokers)) {
            for (Invoker<T> invoker : invokers) {
                String applicationName = invoker.getUrl().getRemoteApplication();
                if (!StringUtils.isNotEmpty((String)applicationName) || "unknown".equals(applicationName)) continue;
                currentApplication.add(applicationName);
            }
        }
        if (!this.remoteAppName.equals(currentApplication)) {
            MeshRuleRouter meshRuleRouter = this;
            synchronized (meshRuleRouter) {
                HashSet current = new HashSet(currentApplication);
                HashSet<String> previous = new HashSet<String>(this.remoteAppName);
                previous.removeAll(currentApplication);
                current.removeAll(this.remoteAppName);
                for (String app : current) {
                    this.meshRuleManager.register(app, this);
                }
                for (String app : previous) {
                    this.meshRuleManager.unregister(app, this);
                }
                this.remoteAppName = currentApplication;
            }
        }
    }

    @Override
    public synchronized void onRuleChange(String appName, List<Map<String, Object>> rules) {
        ConcurrentHashMap<String, VsDestinationGroup> appToVDGroup = new ConcurrentHashMap<String, VsDestinationGroup>(this.meshRuleCache.getAppToVDGroup());
        try {
            VsDestinationGroup vsDestinationGroup = new VsDestinationGroup();
            vsDestinationGroup.setAppName(appName);
            for (Map<String, Object> rule : rules) {
                if ("DestinationRule".equals(rule.get("kind"))) {
                    DestinationRule destinationRule = (DestinationRule)PojoUtils.mapToPojo(rule, DestinationRule.class);
                    vsDestinationGroup.getDestinationRuleList().add(destinationRule);
                    continue;
                }
                if (!"VirtualService".equals(rule.get("kind"))) continue;
                VirtualServiceRule virtualServiceRule = (VirtualServiceRule)PojoUtils.mapToPojo(rule, VirtualServiceRule.class);
                vsDestinationGroup.getVirtualServiceRuleList().add(virtualServiceRule);
            }
            if (vsDestinationGroup.isValid()) {
                appToVDGroup.put(appName, vsDestinationGroup);
            }
        }
        catch (Throwable t) {
            logger.error("Error occurred when parsing rule component.", t);
        }
        this.computeSubset(appToVDGroup);
    }

    @Override
    public synchronized void clearRule(String appName) {
        ConcurrentHashMap<String, VsDestinationGroup> appToVDGroup = new ConcurrentHashMap<String, VsDestinationGroup>(this.meshRuleCache.getAppToVDGroup());
        appToVDGroup.remove(appName);
        this.computeSubset(appToVDGroup);
    }

    protected void computeSubset(Map<String, VsDestinationGroup> vsDestinationGroupMap) {
        this.meshRuleCache = MeshRuleCache.build(this.getUrl().getProtocolServiceKey(), this.invokerList, vsDestinationGroupMap);
    }

    @Override
    public void stop() {
        for (String app : this.remoteAppName) {
            this.meshRuleManager.unregister(app, this);
        }
    }

    @Deprecated
    public Set<String> getRemoteAppName() {
        return this.remoteAppName;
    }

    @Deprecated
    public BitList<Invoker<T>> getInvokerList() {
        return this.invokerList;
    }

    @Deprecated
    public MeshRuleCache<T> getMeshRuleCache() {
        return this.meshRuleCache;
    }
}

