/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceModel;

public class ConsumerModel
extends ServiceModel {
    private final Set<String> apps = new TreeSet<String>();
    private final Map<String, AsyncMethodInfo> methodConfigs;
    private Map<Method, ConsumerMethodModel> methodModels = new HashMap<Method, ConsumerMethodModel>();

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, Map<String, AsyncMethodInfo> methodConfigs) {
        super(proxyObject, serviceKey, serviceModel, referenceConfig);
        Assert.notEmptyString(serviceKey, "Service name can't be null or blank");
        this.methodConfigs = methodConfigs == null ? new HashMap() : methodConfigs;
    }

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, ServiceMetadata metadata, Map<String, AsyncMethodInfo> methodConfigs) {
        super(proxyObject, serviceKey, serviceModel, referenceConfig, metadata);
        Assert.notEmptyString(serviceKey, "Service name can't be null or blank");
        this.methodConfigs = methodConfigs == null ? new HashMap() : methodConfigs;
    }

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, ModuleModel moduleModel, ServiceMetadata metadata, Map<String, AsyncMethodInfo> methodConfigs) {
        super(proxyObject, serviceKey, serviceModel, referenceConfig, moduleModel, metadata);
        Assert.notEmptyString(serviceKey, "Service name can't be null or blank");
        this.methodConfigs = methodConfigs == null ? new HashMap() : methodConfigs;
    }

    public AsyncMethodInfo getMethodConfig(String methodName) {
        return this.methodConfigs.get(methodName);
    }

    public Set<String> getApps() {
        return this.apps;
    }

    public AsyncMethodInfo getAsyncInfo(String methodName) {
        return this.methodConfigs.get(methodName);
    }

    public void initMethodModels() {
        Class<?> serviceInterfaceClass;
        Class<Object>[] interfaceList = this.getProxyObject() == null ? ((serviceInterfaceClass = this.getReferenceConfig().getServiceInterfaceClass()) != null ? new Class[]{serviceInterfaceClass} : new Class[]{}) : this.getProxyObject().getClass().getInterfaces();
        for (Class<?> clazz : interfaceList) {
            for (Method method : clazz.getMethods()) {
                this.methodModels.put(method, new ConsumerMethodModel(method));
            }
        }
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }

    public ConsumerMethodModel getMethodModel(String method) {
        Optional<Map.Entry> consumerMethodModelEntry = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).findFirst();
        return consumerMethodModelEntry.map(Map.Entry::getValue).orElse(null);
    }

    public ConsumerMethodModel getMethodModel(String method, String[] argsType) {
        Optional<ConsumerMethodModel> consumerMethodModel = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).map(Map.Entry::getValue).filter(methodModel -> Arrays.equals(argsType, methodModel.getParameterTypes())).findFirst();
        return consumerMethodModel.orElse(null);
    }

    public List<ConsumerMethodModel> getAllMethodModels() {
        return new ArrayList<ConsumerMethodModel>(this.methodModels.values());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsumerModel that = (ConsumerModel)o;
        return Objects.equals(this.apps, that.apps) && Objects.equals(this.methodConfigs, that.methodConfigs) && Objects.equals(this.methodModels, that.methodModels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.apps, this.methodConfigs, this.methodModels);
    }
}

