/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.probe.StartupProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="startup", summary="Judge if service has started? ")
public class Startup
implements BaseCommand {
    private FrameworkModel frameworkModel;

    public Startup(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        String config = this.frameworkModel.getApplicationModels().stream().map(applicationModel -> applicationModel.getApplicationConfigManager().getApplication()).map(o -> o.orElse(null)).filter(Objects::nonNull).map(ApplicationConfig::getStartupProbe).filter(Objects::nonNull).collect(Collectors.joining(","));
        URL url = URL.valueOf((String)"application://").addParameter("dubbo.application.startup-probe", config);
        List startupProbes = this.frameworkModel.getExtensionLoader(StartupProbe.class).getActivateExtension(url, "dubbo.application.startup-probe");
        if (!startupProbes.isEmpty()) {
            for (StartupProbe startupProbe : startupProbes) {
                if (startupProbe.check()) continue;
                commandContext.setHttpCode(503);
                return "false";
            }
        }
        commandContext.setHttpCode(200);
        return "true";
    }
}

