/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.probe.impl;

import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.qos.probe.ReadinessProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

@Activate
public class ProviderReadinessProbe
implements ReadinessProbe {
    private FrameworkModel frameworkModel;
    private FrameworkServiceRepository serviceRepository;

    public ProviderReadinessProbe(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel != null ? frameworkModel : FrameworkModel.defaultModel();
        this.serviceRepository = this.frameworkModel.getServiceRepository();
    }

    @Override
    public boolean check() {
        List providerModelList = this.serviceRepository.allProviderModels();
        if (providerModelList.isEmpty()) {
            return true;
        }
        boolean hasService = false;
        block0: for (ProviderModel providerModel : providerModelList) {
            List statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedUrl : statedUrls) {
                if (!statedUrl.isRegistered()) continue;
                hasService = true;
                continue block0;
            }
        }
        return hasService;
    }
}

