/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.reporter.FrameworkStatusReportService;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.InvokersChangedListener;
import org.apache.dubbo.registry.client.migration.MigrationAddressComparator;
import org.apache.dubbo.registry.client.migration.MigrationClusterInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleListener;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class MigrationInvoker<T>
implements MigrationClusterInvoker<T> {
    private Logger logger = LoggerFactory.getLogger(MigrationInvoker.class);
    private URL url;
    private URL consumerUrl;
    private Cluster cluster;
    private Registry registry;
    private Class<T> type;
    private RegistryProtocol registryProtocol;
    private MigrationRuleListener migrationRuleListener;
    private ConsumerModel consumerModel;
    private FrameworkStatusReportService reportService;
    private volatile ClusterInvoker<T> invoker;
    private volatile ClusterInvoker<T> serviceDiscoveryInvoker;
    private volatile ClusterInvoker<T> currentAvailableInvoker;
    private volatile MigrationStep step;
    private volatile MigrationRule rule;
    private volatile int promotion = 100;

    public MigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        this(null, null, registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    public MigrationInvoker(ClusterInvoker<T> invoker, ClusterInvoker<T> serviceDiscoveryInvoker, RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        this.invoker = invoker;
        this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
        this.registryProtocol = registryProtocol;
        this.cluster = cluster;
        this.registry = registry;
        this.type = type;
        this.url = url;
        this.consumerUrl = consumerUrl;
        this.consumerModel = (ConsumerModel)consumerUrl.getServiceModel();
        this.reportService = (FrameworkStatusReportService)consumerUrl.getOrDefaultApplicationModel().getBeanFactory().getBean(FrameworkStatusReportService.class);
        if (this.consumerModel != null) {
            Object object = this.consumerModel.getServiceMetadata().getAttribute("currentClusterInvoker");
            ConcurrentHashMap<Registry, MigrationInvoker> invokerMap = object instanceof Map ? (ConcurrentHashMap<Registry, MigrationInvoker>)object : new ConcurrentHashMap<Registry, MigrationInvoker>();
            invokerMap.put(registry, this);
            this.consumerModel.getServiceMetadata().addAttribute("currentClusterInvoker", invokerMap);
        }
    }

    public ClusterInvoker<T> getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClusterInvoker<T> invoker) {
        this.invoker = invoker;
    }

    public ClusterInvoker<T> getServiceDiscoveryInvoker() {
        return this.serviceDiscoveryInvoker;
    }

    public void setServiceDiscoveryInvoker(ClusterInvoker<T> serviceDiscoveryInvoker) {
        this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
    }

    public ClusterInvoker<T> getCurrentAvailableInvoker() {
        return this.currentAvailableInvoker;
    }

    public Class<T> getInterface() {
        return this.type;
    }

    @Override
    public void reRefer(URL newSubscribeUrl) {
        this.url = this.url.addParameter("refer", StringUtils.toQueryString((Map)newSubscribeUrl.getParameters()));
        if (this.invoker != null && !this.invoker.isDestroyed()) {
            this.doReSubscribe(this.invoker, newSubscribeUrl);
        }
        if (this.serviceDiscoveryInvoker != null && !this.serviceDiscoveryInvoker.isDestroyed()) {
            this.doReSubscribe(this.serviceDiscoveryInvoker, newSubscribeUrl);
        }
    }

    private void doReSubscribe(ClusterInvoker<T> invoker, URL newSubscribeUrl) {
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        URL oldSubscribeUrl = directory.getRegisteredConsumerUrl();
        Registry registry = directory.getRegistry();
        registry.unregister(directory.getRegisteredConsumerUrl());
        directory.unSubscribe(RegistryProtocol.toSubscribeUrl(oldSubscribeUrl));
        if (directory.isShouldRegister()) {
            registry.register(directory.getRegisteredConsumerUrl());
            directory.setRegisteredConsumerUrl(newSubscribeUrl);
        }
        directory.buildRouterChain(newSubscribeUrl);
        directory.subscribe(RegistryProtocol.toSubscribeUrl(newSubscribeUrl));
    }

    @Override
    public boolean migrateToForceInterfaceInvoker(MigrationRule newRule) {
        CountDownLatch latch = new CountDownLatch(1);
        this.refreshInterfaceInvoker(latch);
        if (this.serviceDiscoveryInvoker == null) {
            this.currentAvailableInvoker = this.invoker;
            return true;
        }
        this.waitAddressNotify(newRule, latch);
        if (newRule.getForce(this.consumerUrl)) {
            this.currentAvailableInvoker = this.invoker;
            this.destroyServiceDiscoveryInvoker();
            return true;
        }
        Set detectors = ScopeModelUtil.getApplicationModel(this.consumerUrl == null ? null : this.consumerUrl.getScopeModel()).getExtensionLoader(MigrationAddressComparator.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)detectors) && detectors.stream().allMatch(comparator -> comparator.shouldMigrate(this.invoker, this.serviceDiscoveryInvoker, newRule))) {
            this.currentAvailableInvoker = this.invoker;
            this.destroyServiceDiscoveryInvoker();
            return true;
        }
        if (this.step == MigrationStep.FORCE_APPLICATION) {
            this.destroyInterfaceInvoker();
        }
        return false;
    }

    @Override
    public boolean migrateToForceApplicationInvoker(MigrationRule newRule) {
        CountDownLatch latch = new CountDownLatch(1);
        this.refreshServiceDiscoveryInvoker(latch);
        if (this.invoker == null) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
            return true;
        }
        this.waitAddressNotify(newRule, latch);
        if (newRule.getForce(this.consumerUrl)) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
            this.destroyInterfaceInvoker();
            return true;
        }
        Set detectors = ScopeModelUtil.getApplicationModel(this.consumerUrl == null ? null : this.consumerUrl.getScopeModel()).getExtensionLoader(MigrationAddressComparator.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)detectors) && detectors.stream().allMatch(comparator -> comparator.shouldMigrate(this.serviceDiscoveryInvoker, this.invoker, newRule))) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
            this.destroyInterfaceInvoker();
            return true;
        }
        if (this.step == MigrationStep.FORCE_INTERFACE) {
            this.destroyServiceDiscoveryInvoker();
        }
        return false;
    }

    @Override
    public void migrateToApplicationFirstInvoker(MigrationRule newRule) {
        CountDownLatch latch = new CountDownLatch(0);
        this.refreshInterfaceInvoker(latch);
        this.refreshServiceDiscoveryInvoker(latch);
        this.calcPreferredInvoker(newRule);
    }

    private void waitAddressNotify(MigrationRule newRule, CountDownLatch latch) {
        int delay = newRule.getDelay(this.consumerUrl);
        if (delay > 0) {
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupter when waiting for address notify!" + e);
            }
        } else {
            delay = 0;
        }
        try {
            latch.await(delay, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupter when waiting for address notify!" + e);
        }
    }

    public Result invoke(Invocation invocation) throws RpcException {
        if (this.currentAvailableInvoker != null) {
            if (this.step == MigrationStep.APPLICATION_FIRST && this.promotion < 100 && ThreadLocalRandom.current().nextDouble(100.0) > (double)this.promotion) {
                return this.invoker.invoke(invocation);
            }
            return this.currentAvailableInvoker.invoke(invocation);
        }
        switch (this.step) {
            case APPLICATION_FIRST: {
                if (this.checkInvokerAvailable(this.serviceDiscoveryInvoker)) {
                    this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
                    break;
                }
                if (this.checkInvokerAvailable(this.invoker)) {
                    this.currentAvailableInvoker = this.invoker;
                    break;
                }
                this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
                break;
            }
            case FORCE_APPLICATION: {
                this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
                break;
            }
            default: {
                this.currentAvailableInvoker = this.invoker;
            }
        }
        return this.currentAvailableInvoker.invoke(invocation);
    }

    public boolean isAvailable() {
        return this.currentAvailableInvoker != null ? this.currentAvailableInvoker.isAvailable() : this.invoker != null && this.invoker.isAvailable() || this.serviceDiscoveryInvoker != null && this.serviceDiscoveryInvoker.isAvailable();
    }

    public void destroy() {
        Object object;
        if (this.migrationRuleListener != null) {
            this.migrationRuleListener.removeMigrationInvoker(this);
        }
        if (this.invoker != null) {
            this.invoker.destroy();
        }
        if (this.serviceDiscoveryInvoker != null) {
            this.serviceDiscoveryInvoker.destroy();
        }
        if (this.consumerModel != null && (object = this.consumerModel.getServiceMetadata().getAttribute("currentClusterInvoker")) instanceof Map) {
            Map invokerMap = (Map)object;
            invokerMap.remove(this.registry);
            if (invokerMap.isEmpty()) {
                this.consumerModel.getServiceMetadata().getAttributeMap().remove("currentClusterInvoker");
            }
        }
    }

    public URL getUrl() {
        if (this.currentAvailableInvoker != null) {
            return this.currentAvailableInvoker.getUrl();
        }
        if (this.invoker != null) {
            return this.invoker.getUrl();
        }
        if (this.serviceDiscoveryInvoker != null) {
            return this.serviceDiscoveryInvoker.getUrl();
        }
        return this.consumerUrl;
    }

    public URL getRegistryUrl() {
        if (this.currentAvailableInvoker != null) {
            return this.currentAvailableInvoker.getRegistryUrl();
        }
        if (this.invoker != null) {
            return this.invoker.getRegistryUrl();
        }
        if (this.serviceDiscoveryInvoker != null) {
            return this.serviceDiscoveryInvoker.getRegistryUrl();
        }
        return this.url;
    }

    public Directory<T> getDirectory() {
        if (this.currentAvailableInvoker != null) {
            return this.currentAvailableInvoker.getDirectory();
        }
        if (this.invoker != null) {
            return this.invoker.getDirectory();
        }
        if (this.serviceDiscoveryInvoker != null) {
            return this.serviceDiscoveryInvoker.getDirectory();
        }
        return null;
    }

    public boolean isDestroyed() {
        return this.currentAvailableInvoker != null ? this.currentAvailableInvoker.isDestroyed() : !(this.invoker != null && !this.invoker.isDestroyed() || this.serviceDiscoveryInvoker != null && !this.serviceDiscoveryInvoker.isDestroyed());
    }

    @Override
    public boolean isServiceDiscovery() {
        return false;
    }

    @Override
    public MigrationStep getMigrationStep() {
        return this.step;
    }

    @Override
    public void setMigrationStep(MigrationStep step) {
        this.step = step;
    }

    @Override
    public MigrationRule getMigrationRule() {
        return this.rule;
    }

    @Override
    public void setMigrationRule(MigrationRule rule) {
        this.rule = rule;
        this.promotion = rule.getProportion(this.consumerUrl);
    }

    protected void destroyServiceDiscoveryInvoker() {
        if (this.invoker != null) {
            this.currentAvailableInvoker = this.invoker;
        }
        if (this.serviceDiscoveryInvoker != null && !this.serviceDiscoveryInvoker.isDestroyed()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Destroying instance address invokers, will not listen for address changes until re-subscribed, " + this.type.getName());
            }
            this.serviceDiscoveryInvoker.destroy();
            this.serviceDiscoveryInvoker = null;
        }
    }

    protected void refreshServiceDiscoveryInvoker(CountDownLatch latch) {
        this.clearListener(this.serviceDiscoveryInvoker);
        if (this.needRefresh(this.serviceDiscoveryInvoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Re-subscribing instance addresses, current interface " + this.type.getName());
            }
            if (this.serviceDiscoveryInvoker != null) {
                this.serviceDiscoveryInvoker.destroy();
            }
            this.serviceDiscoveryInvoker = this.registryProtocol.getServiceDiscoveryInvoker(this.cluster, this.registry, this.type, this.url);
        }
        this.setListener(this.serviceDiscoveryInvoker, () -> {
            latch.countDown();
            if (this.reportService.hasReporter()) {
                this.reportService.reportConsumptionStatus((Object)this.reportService.createConsumptionReport(this.consumerUrl.getServiceInterface(), this.consumerUrl.getVersion(), this.consumerUrl.getGroup(), "app"));
            }
            if (this.step == MigrationStep.APPLICATION_FIRST) {
                this.calcPreferredInvoker(this.rule);
            }
        });
    }

    protected void refreshInterfaceInvoker(CountDownLatch latch) {
        this.clearListener(this.invoker);
        if (this.needRefresh(this.invoker)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Re-subscribing interface addresses for interface " + this.type.getName());
            }
            if (this.invoker != null) {
                this.invoker.destroy();
            }
            this.invoker = this.registryProtocol.getInvoker(this.cluster, this.registry, this.type, this.url);
        }
        this.setListener(this.invoker, () -> {
            latch.countDown();
            if (this.reportService.hasReporter()) {
                this.reportService.reportConsumptionStatus((Object)this.reportService.createConsumptionReport(this.consumerUrl.getServiceInterface(), this.consumerUrl.getVersion(), this.consumerUrl.getGroup(), "interface"));
            }
            if (this.step == MigrationStep.APPLICATION_FIRST) {
                this.calcPreferredInvoker(this.rule);
            }
        });
    }

    private synchronized void calcPreferredInvoker(MigrationRule migrationRule) {
        if (this.serviceDiscoveryInvoker == null || this.invoker == null) {
            return;
        }
        Set detectors = ScopeModelUtil.getApplicationModel(this.consumerUrl == null ? null : this.consumerUrl.getScopeModel()).getExtensionLoader(MigrationAddressComparator.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)detectors)) {
            this.currentAvailableInvoker = detectors.stream().allMatch(comparator -> comparator.shouldMigrate(this.serviceDiscoveryInvoker, this.invoker, migrationRule)) ? this.serviceDiscoveryInvoker : this.invoker;
        }
    }

    protected void destroyInterfaceInvoker() {
        if (this.serviceDiscoveryInvoker != null) {
            this.currentAvailableInvoker = this.serviceDiscoveryInvoker;
        }
        if (this.invoker != null && !this.invoker.isDestroyed()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Destroying interface address invokers, will not listen for address changes until re-subscribed, " + this.type.getName());
            }
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private void clearListener(ClusterInvoker<T> invoker) {
        if (invoker == null) {
            return;
        }
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        directory.setInvokersChangedListener(null);
    }

    private void setListener(ClusterInvoker<T> invoker, InvokersChangedListener listener) {
        if (invoker == null) {
            return;
        }
        DynamicDirectory directory = (DynamicDirectory)invoker.getDirectory();
        directory.setInvokersChangedListener(listener);
    }

    private boolean needRefresh(ClusterInvoker<T> invoker) {
        return invoker == null || invoker.isDestroyed() || !invoker.hasProxyInvokers();
    }

    public boolean checkInvokerAvailable(ClusterInvoker<T> invoker) {
        return invoker != null && !invoker.isDestroyed() && invoker.isAvailable();
    }

    protected void setCurrentAvailableInvoker(ClusterInvoker<T> currentAvailableInvoker) {
        this.currentAvailableInvoker = currentAvailableInvoker;
    }

    protected void setMigrationRuleListener(MigrationRuleListener migrationRuleListener) {
        this.migrationRuleListener = migrationRuleListener;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public URL getConsumerUrl() {
        return this.consumerUrl;
    }
}

