/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.UnaryServerStream;
import org.apache.dubbo.triple.TripleWrapper;

public abstract class AbstractServerStream
extends AbstractStream
implements Stream {
    private final ProviderModel providerModel;
    private final List<HeaderFilter> headerFilters;
    private ServiceDescriptor serviceDescriptor;
    private List<MethodDescriptor> methodDescriptors;
    private Invoker<?> invoker;

    protected AbstractServerStream(URL url) {
        this(url, AbstractServerStream.lookupProviderModel(url));
    }

    protected AbstractServerStream(URL url, ProviderModel providerModel) {
        this(url, AbstractServerStream.lookupExecutor(providerModel), providerModel);
    }

    protected AbstractServerStream(URL url, Executor executor, ProviderModel providerModel) {
        super(url, executor);
        this.providerModel = providerModel;
        this.serialize(this.getUrl().getParameter("serialization", "hessian2"));
        this.headerFilters = url.getOrDefaultApplicationModel().getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
    }

    private static Executor lookupExecutor(ProviderModel providerModel) {
        if (providerModel == null) {
            return null;
        }
        return (ExecutorService)providerModel.getServiceMetadata().getAttribute("threadpool");
    }

    public static UnaryServerStream unary(URL url) {
        return new UnaryServerStream(url);
    }

    public static ServerStream stream(URL url) {
        return new ServerStream(url);
    }

    public static AbstractServerStream newServerStream(URL url, boolean unary) {
        return unary ? AbstractServerStream.unary(url) : AbstractServerStream.stream(url);
    }

    private static ProviderModel lookupProviderModel(URL url) {
        FrameworkServiceRepository repo = ScopeModelUtil.getFrameworkModel((ScopeModel)url.getScopeModel()).getServiceRepository();
        ProviderModel model = repo.lookupExportedService(url.getServiceKey());
        if (model != null) {
            ClassLoadUtil.switchContextLoader(model.getClassLoader());
        }
        return model;
    }

    public List<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public AbstractServerStream methods(List<MethodDescriptor> methods) {
        this.methodDescriptors = methods;
        return this;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public List<HeaderFilter> getHeaderFilters() {
        return this.headerFilters;
    }

    public ProviderModel getProviderModel() {
        return this.providerModel;
    }

    protected RpcInvocation buildInvocation(Metadata metadata) {
        RpcInvocation inv = new RpcInvocation(this.getUrl().getServiceModel(), this.getMethodName(), this.getServiceDescriptor().getInterfaceName(), this.getUrl().getProtocolServiceKey(), this.getMethodDescriptor().getRealParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(this.getUrl().getServiceKey());
        inv.setReturnTypes(this.getMethodDescriptor().getReturnTypes());
        Map<String, Object> attachments = this.parseMetadataToAttachmentMap(metadata);
        inv.setObjectAttachments(attachments);
        CharSequence timeout = metadata.get(TripleHeaderEnum.TIMEOUT.getHeader());
        try {
            Long timeoutInNanos;
            if (!Objects.isNull(timeout) && !Objects.isNull(timeoutInNanos = this.parseTimeoutToNanos(timeout.toString()))) {
                inv.setAttachment("timeout", (Object)timeoutInNanos);
            }
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeout, this.getServiceDescriptor().getInterfaceName(), this.getMethodName()));
        }
        this.invokeHeaderFilter(inv);
        return inv;
    }

    protected void invokeHeaderFilter(RpcInvocation inv) throws RpcException {
        for (HeaderFilter headerFilter : this.getHeaderFilters()) {
            headerFilter.invoke(this.getInvoker(), inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RpcInvocation buildUnaryInvocation(Metadata metadata, byte[] data) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getProviderModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getProviderModel().getServiceInterfaceClass().getClassLoader());
            }
            if (this.needDeserializeWrapper(this.getMethodDescriptor())) {
                TripleWrapper.TripleRequestWrapper wrapper = this.deserializeWrapperSetMdIfNeed(data);
                if (wrapper == null) {
                    RpcInvocation rpcInvocation = null;
                    return rpcInvocation;
                }
                RpcInvocation inv = this.buildInvocation(metadata);
                inv.setArguments(this.unwrapReq(this.getUrl(), wrapper, this.getMultipleSerialization()));
                RpcInvocation rpcInvocation = inv;
                return rpcInvocation;
            }
            RpcInvocation inv = this.buildInvocation(metadata);
            inv.setArguments(new Object[]{this.unpack(data, this.getMethodDescriptor().getParameterClasses()[0])});
            RpcInvocation rpcInvocation = inv;
            return rpcInvocation;
        }
        catch (RpcException rpcException) {
            this.transportError(GrpcStatus.getStatus(rpcException, rpcException.getMessage()));
            RpcInvocation rpcInvocation = null;
            return rpcInvocation;
        }
        catch (Throwable throwable) {
            LOGGER.warn("Decode request failed:", throwable);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Decode request failed:" + throwable.getMessage()));
            RpcInvocation rpcInvocation = null;
            return rpcInvocation;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] deserializeRequest(byte[] data) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getProviderModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getProviderModel().getServiceInterfaceClass().getClassLoader());
            }
            if (this.needDeserializeWrapper(this.getMethodDescriptor())) {
                TripleWrapper.TripleRequestWrapper wrapper = this.deserializeWrapperSetMdIfNeed(data);
                if (wrapper == null) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                Object[] objectArray = this.unwrapReq(this.getUrl(), wrapper, this.getMultipleSerialization());
                return objectArray;
            }
            Object[] wrapper = new Object[]{this.unpack(data, this.getMethodDescriptor().getParameterClasses()[0])};
            return wrapper;
        }
        catch (Throwable throwable) {
            LOGGER.warn("Decode request failed:", throwable);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Decode request failed:" + throwable.getMessage()));
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    private boolean needDeserializeWrapper(MethodDescriptor md) {
        if (md == null) {
            return true;
        }
        return this.getMethodDescriptor().isNeedWrap();
    }

    private TripleWrapper.TripleRequestWrapper deserializeWrapperSetMdIfNeed(byte[] data) {
        TripleWrapper.TripleRequestWrapper wrapper = this.unpack(data, TripleWrapper.TripleRequestWrapper.class);
        if (!this.getSerializeType().equals(this.convertHessianFromWrapper(wrapper.getSerializeType()))) {
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INVALID_ARGUMENT).withDescription("Received inconsistent serialization type from client, reject to deserialize! Expected:" + this.getSerializeType() + " Actual:" + this.convertHessianFromWrapper(wrapper.getSerializeType())));
            return null;
        }
        if (this.getMethodDescriptor() == null) {
            Object[] paramTypes = (String[])wrapper.getArgTypesList().toArray((Object[])new String[wrapper.getArgsCount()]);
            for (MethodDescriptor descriptor : this.getMethodDescriptors()) {
                if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                this.method(descriptor);
                break;
            }
            if (this.getMethodDescriptor() == null) {
                this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Method :" + this.getMethodName() + "[" + Arrays.toString(paramTypes) + "] not found of service:" + this.getServiceDescriptor().getInterfaceName()));
                return null;
            }
        }
        return wrapper;
    }

    private Object[] unwrapReq(URL url, TripleWrapper.TripleRequestWrapper wrap, MultipleSerialization multipleSerialization) {
        String serializeType = this.convertHessianFromWrapper(wrap.getSerializeType());
        try {
            Object[] arguments = new Object[wrap.getArgsCount()];
            for (int i = 0; i < arguments.length; ++i) {
                Object obj;
                ByteArrayInputStream bais = new ByteArrayInputStream(wrap.getArgs(i).toByteArray());
                arguments[i] = obj = multipleSerialization.deserialize(url, serializeType, wrap.getArgTypes(i), (InputStream)bais);
            }
            return arguments;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unwrap req: " + e.getMessage(), e);
        }
    }

    protected Metadata createResponseMeta() {
        Metadata metadata = this.createDefaultMetadata();
        metadata.putIfNotNull(TripleHeaderEnum.GRPC_ENCODING.getHeader(), super.getCompressor().getMessageEncoding()).putIfNotNull(TripleHeaderEnum.GRPC_ACCEPT_ENCODING.getHeader(), this.getAcceptEncoding());
        return metadata;
    }

    protected Long parseTimeoutToNanos(String timeoutVal) {
        if (StringUtils.isEmpty((String)timeoutVal) || StringUtils.isContains((String)timeoutVal, (String)"null")) {
            return null;
        }
        long value = Long.parseLong(timeoutVal.substring(0, timeoutVal.length() - 1));
        char unit = timeoutVal.charAt(timeoutVal.length() - 1);
        switch (unit) {
            case 'n': {
                return value;
            }
            case 'u': {
                return TimeUnit.MICROSECONDS.toNanos(value);
            }
            case 'm': {
                return TimeUnit.MILLISECONDS.toNanos(value);
            }
            case 'S': {
                return TimeUnit.SECONDS.toNanos(value);
            }
            case 'M': {
                return TimeUnit.MINUTES.toNanos(value);
            }
            case 'H': {
                return TimeUnit.HOURS.toNanos(value);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] encodeResponse(Object value) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getProviderModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getProviderModel().getServiceInterfaceClass().getClassLoader());
            }
            Object message = this.getMethodDescriptor().isNeedWrap() ? this.wrapResp(this.getUrl(), this.getSerializeType(), value, this.getMethodDescriptor(), this.getMultipleSerialization()) : (Message)value;
            byte[] out = this.pack(message);
            byte[] byArray = super.compress(out);
            return byArray;
        }
        catch (Throwable throwable) {
            LOGGER.error("Encode Response data error ", throwable);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNKNOWN).withCause(throwable).withDescription("Encode Response data error"));
            byte[] byArray = null;
            return byArray;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            super.execute(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    LOGGER.error("Exception processing triple message", t);
                    this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Exception in invoker chain :" + t.getMessage()).withCause(t));
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Provider's thread pool is full", (Throwable)e);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription("Provider's thread pool is full"));
        }
        catch (Throwable t) {
            LOGGER.error("Provider submit request to thread pool error ", t);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(t).withDescription("Provider's error"));
        }
    }

    public AbstractServerStream service(ServiceDescriptor sd) {
        this.setServiceDescriptor(sd);
        return this;
    }

    public AbstractServerStream invoker(Invoker<?> invoker) {
        this.invoker = invoker;
        return this;
    }

    @Override
    protected void cancelByRemoteReset() {
        this.getCancellationContext().cancel(null);
    }

    @Override
    protected void cancelByLocal(Throwable throwable) {
        this.inboundTransportObserver().onError(GrpcStatus.fromCode(GrpcStatus.Code.CANCELLED).withCause(throwable));
    }

    public TripleWrapper.TripleResponseWrapper wrapResp(URL url, String serializeType, Object resp, MethodDescriptor desc, MultipleSerialization multipleSerialization) {
        try {
            TripleWrapper.TripleResponseWrapper.Builder builder = TripleWrapper.TripleResponseWrapper.newBuilder().setType(desc.getReturnClass().getName()).setSerializeType(this.convertHessianToWrapper(serializeType));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            multipleSerialization.serialize(url, serializeType, desc.getReturnClass().getName(), resp, (OutputStream)bos);
            builder.setData(ByteString.copyFrom((byte[])bos.toByteArray()));
            bos.close();
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack wrapper req", e);
        }
    }
}

