/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelPromise;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.OutboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.WriteQueue;
import org.apache.dubbo.rpc.protocol.tri.command.CancelQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.command.DataQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.command.HeaderQueueCommand;

public class ClientOutboundTransportObserver
extends OutboundTransportObserver {
    private final ChannelPromise promise;

    public ClientOutboundTransportObserver(WriteQueue writeQueue, ChannelPromise promise) {
        super(writeQueue);
        this.promise = promise;
    }

    @Override
    protected void doOnMetadata(Metadata metadata, boolean endStream) {
        this.writeQueue.enqueue(HeaderQueueCommand.createHeaders(metadata, endStream), true).addListener(future -> {
            if (!future.isSuccess()) {
                this.promise.tryFailure(future.cause());
            }
        });
    }

    @Override
    protected void doOnData(byte[] data, boolean endStream) {
        this.writeQueue.enqueue(DataQueueCommand.createGrpcCommand(data, endStream, true), true).addListener(future -> {
            if (!future.isSuccess()) {
                this.promise.tryFailure(future.cause());
            }
        });
    }

    @Override
    protected void doOnError(GrpcStatus status) {
        this.writeQueue.enqueue(CancelQueueCommand.createCommand(status), true).addListener(future -> {
            if (future.isSuccess()) {
                this.promise.trySuccess();
            } else {
                this.promise.tryFailure(future.cause());
            }
        });
    }

    @Override
    protected void doOnComplete() {
        this.writeQueue.enqueue(DataQueueCommand.createGrpcCommand(true), true).addListener(future -> {
            if (future.isSuccess()) {
                this.promise.trySuccess();
            } else {
                this.promise.tryFailure(future.cause());
            }
        });
    }
}

