/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.RpcException;

public class GrpcStatus {
    public final Code code;
    public Throwable cause;
    public String description;

    public GrpcStatus(Code code, Throwable cause, String description) {
        this.code = code;
        this.cause = cause;
        this.description = description;
    }

    public static GrpcStatus fromCode(int code) {
        return GrpcStatus.fromCode(Code.fromCode(code));
    }

    public static GrpcStatus fromCode(Code code) {
        return new GrpcStatus(code, null, null);
    }

    public static GrpcStatus fromCodeWithDescription(Code code, String description) {
        return new GrpcStatus(code, null, description);
    }

    public static byte toDubboStatus(Code code) {
        byte status;
        switch (code) {
            case OK: {
                status = 20;
                break;
            }
            case UNKNOWN: {
                status = 70;
                break;
            }
            case DEADLINE_EXCEEDED: {
                status = 31;
                break;
            }
            case RESOURCE_EXHAUSTED: {
                status = 100;
                break;
            }
            case UNIMPLEMENTED: {
                status = 60;
                break;
            }
            case INVALID_ARGUMENT: {
                status = 40;
                break;
            }
            case INTERNAL: {
                status = 80;
                break;
            }
            case UNAVAILABLE: 
            case DATA_LOSS: {
                status = 35;
                break;
            }
            default: {
                status = 90;
            }
        }
        return status;
    }

    public static GrpcStatus getStatus(Throwable throwable) {
        return GrpcStatus.getStatus(throwable, null);
    }

    public static GrpcStatus getStatus(Throwable throwable, String description) {
        if (throwable instanceof RpcException) {
            RpcException rpcException = (RpcException)throwable;
            Code code = GrpcStatus.rpcExceptionCodeToGrpcCode(rpcException.getCode());
            return new GrpcStatus(code, throwable, description);
        }
        if (throwable instanceof TimeoutException) {
            return new GrpcStatus(Code.DEADLINE_EXCEEDED, throwable, description);
        }
        return new GrpcStatus(Code.UNKNOWN, throwable, description);
    }

    public static Code rpcExceptionCodeToGrpcCode(int rpcExceptionCode) {
        Code code;
        switch (rpcExceptionCode) {
            case 2: 
            case 8: {
                code = Code.DEADLINE_EXCEEDED;
                break;
            }
            case 4: {
                code = Code.PERMISSION_DENIED;
                break;
            }
            case 1: 
            case 7: {
                code = Code.UNAVAILABLE;
                break;
            }
            case 11: {
                code = Code.NOT_FOUND;
                break;
            }
            case 5: {
                code = Code.INTERNAL;
                break;
            }
            default: {
                code = Code.UNKNOWN;
            }
        }
        return code;
    }

    public static String limitSizeTo4KB(String desc) {
        if (desc.length() < 4096) {
            return desc;
        }
        return desc.substring(0, 4086);
    }

    public static String decodeMessage(String raw) {
        if (StringUtils.isEmpty((String)raw)) {
            return "";
        }
        return QueryStringDecoder.decodeComponent((String)raw);
    }

    public static String encodeMessage(String raw) {
        if (StringUtils.isEmpty((String)raw)) {
            return "";
        }
        return GrpcStatus.encodeComponent(raw);
    }

    public GrpcStatus withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public GrpcStatus withDescription(String description) {
        this.description = description;
        return this;
    }

    public RpcException asException() {
        return new RpcException(this.code.code, this.description, this.cause);
    }

    public String toMessage() {
        String msg;
        if (this.cause == null) {
            msg = this.description;
        } else {
            String placeHolder = this.description == null ? "" : this.description;
            msg = StringUtils.toString((String)placeHolder, (Throwable)this.cause);
        }
        if (msg == null) {
            return "";
        }
        String output = GrpcStatus.limitSizeTo4KB(msg);
        return GrpcStatus.encodeComponent(output);
    }

    private static String encodeComponent(String raw) {
        QueryStringEncoder encoder = new QueryStringEncoder("");
        encoder.addParam("", raw);
        return encoder.toString().substring(2);
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        final int code;

        private Code(int code) {
            this.code = code;
        }

        public static boolean isOk(Integer status) {
            return status == Code.OK.code;
        }

        public static Code fromCode(int code) {
            for (Code value : Code.values()) {
                if (value.code != code) continue;
                return value;
            }
            throw new IllegalStateException("Can not find status for code: " + code);
        }
    }
}

