/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TransportState;
import org.apache.dubbo.rpc.protocol.tri.WriteQueue;

public abstract class OutboundTransportObserver
implements TransportObserver {
    protected final TransportState state = new TransportState();
    protected final WriteQueue writeQueue;

    public OutboundTransportObserver(WriteQueue writeQueue) {
        this.writeQueue = writeQueue;
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream) {
        this.checkSendMeta(metadata, endStream);
        this.doOnMetadata(metadata, endStream);
    }

    protected void checkSendMeta(Object metadata, boolean endStream) {
        if (endStream) {
            if (!this.state.allowSendEndStream()) {
                throw new IllegalStateException("Metadata endStream already sent to peer, send " + metadata + " failed!");
            }
            this.state.setMetaSend();
            this.state.setEndStreamSend();
        } else {
            if (!this.state.allowSendMeta()) {
                throw new IllegalStateException("Metadata already sent to peer, send " + metadata + " failed!");
            }
            this.state.setMetaSend();
        }
    }

    @Override
    public void onData(byte[] data, boolean endStream) {
        this.checkSendData(endStream);
        this.doOnData(data, endStream);
    }

    protected void checkSendData(boolean endStream) {
        if (!this.state.allowSendData()) {
            throw new IllegalStateException("data has not sent to peer!");
        }
        if (endStream) {
            this.state.setEndStreamSend();
        }
    }

    @Override
    public void onError(GrpcStatus status) {
        if (!this.state.allowSendReset()) {
            throw new IllegalStateException("Duplicated rst!");
        }
        this.state.setResetSend();
        this.doOnError(status);
    }

    @Override
    public void onComplete() {
        if (!this.state.allowSendEndStream()) {
            throw new IllegalStateException("Stream already closed!");
        }
        this.state.setEndStreamSend();
        this.doOnComplete();
    }

    protected abstract void doOnMetadata(Metadata var1, boolean var2);

    protected abstract void doOnData(byte[] var1, boolean var2);

    protected abstract void doOnError(GrpcStatus var1);

    protected abstract void doOnComplete();
}

