/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.OutboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.WriteQueue;
import org.apache.dubbo.rpc.protocol.tri.command.CancelQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.command.DataQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.command.HeaderQueueCommand;

public class ServerOutboundTransportObserver
extends OutboundTransportObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerOutboundTransportObserver.class);

    public ServerOutboundTransportObserver(WriteQueue queue) {
        super(queue);
    }

    public void onMetadata(Http2Headers headers, boolean endStream) {
        this.checkSendMeta(headers, endStream);
        this.writeQueue.enqueue(HeaderQueueCommand.createHeaders(headers, endStream), true).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.warn("send header error endStream=" + endStream, future.cause());
            }
        });
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream) {
        this.doOnMetadata(metadata, endStream);
    }

    @Override
    public void onData(byte[] data, boolean endStream) {
        this.doOnData(data, endStream);
    }

    @Override
    protected void doOnMetadata(Metadata metadata, boolean endStream) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(true);
        metadata.forEach(e -> {
            Http2Headers cfr_ignored_0 = (Http2Headers)headers.set(e.getKey(), e.getValue());
        });
        this.onMetadata((Http2Headers)headers, endStream);
    }

    @Override
    protected void doOnData(byte[] data, boolean endStream) {
        this.writeQueue.enqueue(DataQueueCommand.createGrpcCommand(data, endStream, false), true).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.warn("send data error endStream=" + endStream, future.cause());
            }
        });
    }

    @Override
    protected void doOnError(GrpcStatus status) {
        this.writeQueue.enqueue(CancelQueueCommand.createCommand(status), true).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.warn("write reset error", future.cause());
            }
        });
    }

    @Override
    protected void doOnComplete() {
    }
}

