/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

public class TransportState {
    private static final int META_SEND = 1;
    private static final int RESET_SEND = 2;
    private static final int END_STREAM_SEND = 4;
    private static final int SERVER_SEND_STREAM_RECEIVED = 8;
    private static final int ALLOW_META_SEND = 0;
    private static final int ALLOW_DATA_SEND = 1;
    private volatile int state = 0;

    public void setMetaSend() {
        this.state |= 1;
    }

    public void setResetSend() {
        this.state |= 2;
    }

    public void setEndStreamSend() {
        this.state |= 4;
    }

    public void setServerEndStreamReceived() {
        this.state |= 8;
    }

    public boolean serverSendStreamReceived() {
        return (this.state & 8) > 0;
    }

    public boolean allowSendMeta() {
        return this.state == 0;
    }

    public boolean allowSendReset() {
        return (this.state & 2) != 2;
    }

    public boolean allowSendData() {
        return this.state == 1;
    }

    public boolean allowSendEndStream() {
        return this.allowSendReset() && (this.state & 4) != 4;
    }
}

