/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcDataDecoder;
import org.apache.dubbo.rpc.protocol.tri.TripleClientInboundHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleCommandOutBoundHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;
import org.apache.dubbo.rpc.protocol.tri.TripleHttp2ClientResponseHandler;
import org.apache.dubbo.rpc.protocol.tri.WriteQueue;

public class TripleClientRequestHandler
extends ChannelDuplexHandler {
    private final FrameworkModel frameworkModel;

    public TripleClientRequestHandler(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Request)) {
            super.write(ctx, msg, promise);
            return;
        }
        Request req = (Request)msg;
        Connection connection = Connection.getConnectionFromChannel((Channel)ctx.channel());
        AbstractClientStream stream = AbstractClientStream.newClientStream(req, connection);
        Http2StreamChannelBootstrap streamChannelBootstrap = new Http2StreamChannelBootstrap(ctx.channel());
        streamChannelBootstrap.open().addListener(future -> {
            if (future.isSuccess()) {
                Http2StreamChannel channel = (Http2StreamChannel)future.get();
                channel.pipeline().addLast(new ChannelHandler[]{new TripleCommandOutBoundHandler()}).addLast(new ChannelHandler[]{new TripleHttp2ClientResponseHandler()}).addLast(new ChannelHandler[]{new GrpcDataDecoder(Integer.MAX_VALUE, true)}).addLast(new ChannelHandler[]{new TripleClientInboundHandler()});
                channel.attr(TripleConstant.CLIENT_STREAM_KEY).set((Object)stream);
                DefaultFuture2.addTimeoutListener((long)req.getId(), () -> ((Http2StreamChannel)channel).close());
                WriteQueue writeQueue = new WriteQueue((Channel)channel);
                stream.startCall(writeQueue, promise);
            } else {
                promise.tryFailure(future.cause());
                DefaultFuture2.getFuture((long)req.getId()).cancel();
            }
        });
    }
}

