/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum TripleHeaderEnum {
    AUTHORITY_KEY(":authority"),
    PATH_KEY(":path"),
    HTTP_STATUS_KEY("http-status"),
    STATUS_KEY("grpc-status"),
    MESSAGE_KEY("grpc-message"),
    STATUS_DETAIL_KEY("grpc-status-details-bin"),
    TIMEOUT("grpc-timeout"),
    CONTENT_TYPE_KEY("content-type"),
    CONTENT_PROTO("application/grpc+proto"),
    APPLICATION_GRPC("application/grpc"),
    GRPC_ENCODING("grpc-encoding"),
    GRPC_ACCEPT_ENCODING("grpc-accept-encoding"),
    CONSUMER_APP_NAME_KEY("tri-consumer-appname"),
    SERVICE_VERSION("tri-service-version"),
    SERVICE_GROUP("tri-service-group");

    static Map<String, TripleHeaderEnum> enumMap;
    static Set<String> excludeAttachmentsSet;
    private final String header;

    private TripleHeaderEnum(String header) {
        this.header = header;
    }

    public static TripleHeaderEnum getEnum(String header) {
        return enumMap.get(header);
    }

    public static boolean contains(String header) {
        return enumMap.containsKey(header);
    }

    public static boolean containsExcludeAttachments(String key) {
        return excludeAttachmentsSet.contains(key) || enumMap.containsKey(key);
    }

    public String getHeader() {
        return this.header;
    }

    static {
        enumMap = new HashMap<String, TripleHeaderEnum>();
        excludeAttachmentsSet = new HashSet<String>();
        for (TripleHeaderEnum item : TripleHeaderEnum.values()) {
            enumMap.put(item.getHeader(), item);
        }
        excludeAttachmentsSet.add("group");
        excludeAttachmentsSet.add("interface");
        excludeAttachmentsSet.add("path");
        excludeAttachmentsSet.add("remote.application");
        excludeAttachmentsSet.add("application");
        excludeAttachmentsSet.add("serialization");
        excludeAttachmentsSet.add("te");
    }
}

