/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.Compressor;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Http2HeaderMeta;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public final class TripleHttp2ClientResponseHandler
extends SimpleChannelInboundHandler<Http2StreamFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleHttp2ClientResponseHandler.class);

    public TripleHttp2ClientResponseHandler() {
        super(false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame event = (Http2GoAwayFrame)evt;
            ctx.close();
            LOGGER.debug("Event triggered, event name is: " + event.name() + ", last stream id is: " + event.lastStreamId());
        } else if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else {
            super.channelRead(ctx, (Object)msg);
        }
    }

    private void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame resetFrame) {
        AbstractClientStream clientStream = (AbstractClientStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get();
        LOGGER.warn("Triple Client received remote reset errorCode=" + resetFrame.errorCode());
        clientStream.cancelByRemote();
        ctx.close();
    }

    private void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) {
        String compressorStr;
        Http2Headers headers = msg.headers();
        AbstractClientStream clientStream = (AbstractClientStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get();
        CharSequence messageEncoding = (CharSequence)headers.get((Object)TripleHeaderEnum.GRPC_ENCODING.getHeader());
        if (null != messageEncoding && !"identity".equals(compressorStr = messageEncoding.toString())) {
            Compressor compressor = Compressor.getCompressor(clientStream.getUrl().getOrDefaultFrameworkModel(), compressorStr);
            if (null == compressor) {
                throw GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription(String.format("Grpc-encoding '%s' is not supported", compressorStr)).asException();
            }
            clientStream.setDeCompressor(compressor);
        }
        TransportObserver observer = clientStream.inboundTransportObserver();
        observer.onMetadata(new Http2HeaderMeta(headers), false);
        if (msg.isEndStream()) {
            observer.onComplete();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        AbstractClientStream clientStream = (AbstractClientStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get();
        GrpcStatus status = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(cause);
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.put(TripleHeaderEnum.STATUS_KEY.getHeader(), Integer.toString(status.code.code));
        metadata.put(TripleHeaderEnum.MESSAGE_KEY.getHeader(), status.toMessage());
        LOGGER.warn("Meet Exception on ClientResponseHandler, status code is: " + (Object)((Object)status.code), cause);
        clientStream.inboundMessageObserver().onError((Throwable)status.asException());
        ctx.close();
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        AbstractClientStream clientStream;
        super.channelRead(ctx, (Object)msg.content());
        if (msg.isEndStream() && (clientStream = (AbstractClientStream)ctx.channel().attr(TripleConstant.CLIENT_STREAM_KEY).get()) != null) {
            clientStream.inboundTransportObserver().onComplete();
        }
    }
}

