/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelFuture;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionManager;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.support.RpcUtils;

public class TripleInvoker<T>
extends AbstractInvoker<T> {
    private final Connection connection;
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final Set<Invoker<?>> invokers;

    public TripleInvoker(Class<T> serviceType, URL url, Set<Invoker<?>> invokers) throws RemotingException {
        super(serviceType, url, new String[]{"interface", "group", "token"});
        this.invokers = invokers;
        ConnectionManager connectionManager = (ConnectionManager)url.getOrDefaultFrameworkModel().getExtensionLoader(ConnectionManager.class).getExtension("multiple");
        this.connection = connectionManager.connect(url);
    }

    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        inv.setServiceModel(RpcContext.getServiceContext().getConsumerUrl().getServiceModel());
        inv.setAttachment("path", this.getUrl().getPath());
        inv.setAttachment("serialization", this.getUrl().getParameter("serialization", "hessian2"));
        try {
            int timeout = this.calculateTimeout(invocation, methodName);
            invocation.setAttachment("timeout", (Object)timeout);
            ExecutorService executor = this.getCallbackExecutor(this.getUrl(), (Invocation)inv);
            Request req = new Request();
            req.setVersion(Version.getProtocolVersion());
            req.setTwoWay(true);
            req.setData((Object)inv);
            this.connection.isAvailable();
            DefaultFuture2 future = DefaultFuture2.newFuture((Connection)this.connection, (Request)req, (int)timeout, (ExecutorService)executor);
            CompletableFuture respFuture = future.thenApply(obj -> (AppResponse)obj);
            FutureContext.getContext().setCompatibleFuture(respFuture);
            AsyncRpcResult result = new AsyncRpcResult(respFuture, (Invocation)inv);
            result.setExecutor((Executor)executor);
            if (!this.connection.isAvailable()) {
                Response response = new Response(req.getId(), req.getVersion());
                response.setStatus((byte)35);
                response.setErrorMessage(String.format("Connect to %s failed", new Object[]{this}));
                DefaultFuture2.received((Connection)this.connection, (Response)response);
            } else {
                ChannelFuture writeFuture = this.connection.write((Object)req);
                writeFuture.addListener(future1 -> {
                    if (future1.isSuccess()) {
                        DefaultFuture2.sent((Request)req);
                    } else {
                        Response response = new Response(req.getId(), req.getVersion());
                        response.setStatus((byte)35);
                        response.setErrorMessage(StringUtils.toString((Throwable)future1.cause()));
                        DefaultFuture2.received((Connection)this.connection, (Response)response);
                    }
                });
            }
            return result;
        }
        catch (TimeoutException e) {
            throw new RpcException(2, "Invoke remote method timeout. method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        catch (RemotingException e) {
            throw new RpcException(1, "Failed to invoke remote method: " + invocation.getMethodName() + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        return this.connection.isAvailable();
    }

    public void destroy() {
        if (!super.isDestroyed()) {
            this.destroyLock.lock();
            try {
                if (super.isDestroyed()) {
                    return;
                }
                super.destroy();
                if (this.invokers != null) {
                    this.invokers.remove((Object)this);
                }
                try {
                    this.connection.release();
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
            }
            finally {
                this.destroyLock.unlock();
            }
        }
    }

    private int calculateTimeout(Invocation invocation, String methodName) {
        int timeout;
        if (invocation.get((Object)"timeout") != null) {
            return (Integer)invocation.get((Object)"timeout");
        }
        Object countdown = RpcContext.getClientAttachment().getObjectAttachment("timeout-countdown");
        if (countdown == null) {
            timeout = (int)RpcUtils.getTimeout((URL)this.getUrl(), (String)methodName, (RpcContext)RpcContext.getClientAttachment(), (long)3000L);
            if (this.getUrl().getParameter("enable-timeout-countdown", false)) {
                invocation.setObjectAttachment("_TO", (Object)timeout);
            }
        } else {
            TimeoutCountDown timeoutCountDown = (TimeoutCountDown)countdown;
            timeout = (int)timeoutCountDown.timeRemaining(TimeUnit.MILLISECONDS);
            invocation.setObjectAttachment("_TO", (Object)timeout);
        }
        return timeout;
    }
}

