/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.GracefulShutdown;

public class TripleServerConnectionHandler
extends Http2ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(TripleServerConnectionHandler.class);
    private static final Set<String> QUIET_EXCEPTIONS = new HashSet<String>();
    private static final Set<Class<?>> QUIET_EXCEPTIONS_CLASS = new HashSet();
    private GracefulShutdown gracefulShutdown;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2PingFrame) {
            if (((Http2PingFrame)msg).content() == 40715087873L) {
                if (this.gracefulShutdown == null) {
                    logger.warn("Received GRACEFUL_SHUTDOWN_PING Ack but gracefulShutdown is null");
                } else {
                    this.gracefulShutdown.secondGoAwayAndClose(ctx);
                }
            }
        } else if (msg instanceof Http2GoAwayFrame) {
            ReferenceCountUtil.release((Object)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private boolean isQuiteException(Throwable t) {
        if (QUIET_EXCEPTIONS_CLASS.contains(t.getClass())) {
            return true;
        }
        return QUIET_EXCEPTIONS.contains(t.getClass().getSimpleName());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.isQuiteException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Channel:%s Error", ctx.channel()), cause);
            }
        } else {
            logger.warn(String.format("Channel:%s Error", ctx.channel()), cause);
        }
        ctx.close();
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.gracefulShutdown == null) {
            this.gracefulShutdown = new GracefulShutdown(ctx, "app_requested", promise);
        }
        this.gracefulShutdown.gracefulShutdown();
    }

    static {
        QUIET_EXCEPTIONS.add("NativeIoException");
        QUIET_EXCEPTIONS_CLASS.add(IOException.class);
        QUIET_EXCEPTIONS_CLASS.add(SocketException.class);
    }
}

