/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.InboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerUnaryInboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Stream;

public class UnaryClientStream
extends AbstractClientStream
implements Stream {
    protected UnaryClientStream(URL url) {
        super(url);
    }

    @Override
    protected void doOnStartCall() {
        this.inboundMessageObserver().onNext((Object)this.getRpcInvocation());
        this.inboundMessageObserver().onCompleted();
    }

    @Override
    protected InboundTransportObserver createInboundTransportObserver() {
        return new ClientUnaryInboundTransportObserver();
    }

    private class ClientUnaryInboundTransportObserver
    extends ServerUnaryInboundTransportObserver {
        private ClientUnaryInboundTransportObserver() {
        }

        @Override
        public void onComplete() {
            UnaryClientStream.this.execute(() -> {
                GrpcStatus status = this.extractStatusFromMeta(this.getHeaders());
                if (GrpcStatus.Code.isOk(status.code.code)) {
                    try {
                        AppResponse result;
                        if (!Void.TYPE.equals(UnaryClientStream.this.getMethodDescriptor().getReturnClass())) {
                            if (this.getData() == null) {
                                GrpcStatus clientStatus = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Missing response data");
                                this.onError(clientStatus);
                                return;
                            }
                            Object resp = UnaryClientStream.this.deserializeResponse(this.getData());
                            result = new AppResponse(resp);
                        } else {
                            result = new AppResponse();
                        }
                        Response response = new Response(UnaryClientStream.this.getRequestId(), "1.0.0");
                        result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(this.getTrailers()));
                        response.setResult((Object)result);
                        DefaultFuture2.received((Connection)UnaryClientStream.this.getConnection(), (Response)response);
                    }
                    catch (Exception e) {
                        GrpcStatus clientStatus = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(e).withDescription("Failed to deserialize response");
                        this.onError(clientStatus);
                    }
                } else {
                    this.onError(status);
                }
            });
        }

        @Override
        public void onError(GrpcStatus status) {
            Response response = new Response(UnaryClientStream.this.getRequestId(), "1.0.0");
            response.setErrorMessage(status.description);
            AppResponse result = new AppResponse();
            Metadata trailers = this.getTrailers() == null ? this.getHeaders() : this.getTrailers();
            Throwable trailersException = UnaryClientStream.this.getThrowableFromTrailers(trailers);
            if (trailersException != null) {
                result.setException(trailersException);
            } else {
                result.setException(status.cause);
            }
            result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(trailers));
            response.setResult((Object)result);
            if (!result.hasException()) {
                byte code = GrpcStatus.toDubboStatus(status.code);
                response.setStatus(code);
            }
            DefaultFuture2.received((Connection)UnaryClientStream.this.getConnection(), (Response)response);
        }
    }
}

