/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.InboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerUnaryInboundTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;

public class UnaryServerStream
extends AbstractServerStream
implements Stream {
    protected UnaryServerStream(URL url) {
        super(url);
    }

    @Override
    protected StreamObserver<Object> createStreamObserver() {
        return null;
    }

    @Override
    protected InboundTransportObserver createInboundTransportObserver() {
        return new UnaryServerTransportObserver();
    }

    private class UnaryServerTransportObserver
    extends ServerUnaryInboundTransportObserver {
        private UnaryServerTransportObserver() {
        }

        @Override
        public void onError(GrpcStatus status) {
            UnaryServerStream.this.transportError(status);
        }

        @Override
        public void onComplete() {
            UnaryServerStream.this.execute(() -> {
                if (this.getData() != null) {
                    this.invoke();
                } else {
                    this.onError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Missing request data"));
                }
            });
        }

        public void invoke() {
            RpcInvocation invocation = UnaryServerStream.this.buildUnaryInvocation(this.getHeaders(), this.getData());
            if (invocation == null) {
                return;
            }
            long stInNano = System.nanoTime();
            Result result = UnaryServerStream.this.getInvoker().invoke((Invocation)invocation);
            CompletableFuture future = result.thenApply(Function.identity());
            future.whenComplete((o, throwable) -> {
                if (throwable != null) {
                    Stream.LOGGER.error("Invoke error", throwable);
                    UnaryServerStream.this.transportError(GrpcStatus.getStatus(throwable));
                    return;
                }
                AppResponse response = (AppResponse)o;
                if (response.hasException()) {
                    UnaryServerStream.this.transportError(GrpcStatus.getStatus(response.getException()));
                    return;
                }
                Object timeoutVal = invocation.getObjectAttachment("timeout");
                long cost = System.nanoTime() - stInNano;
                if (timeoutVal != null && cost > (Long)timeoutVal) {
                    Stream.LOGGER.error(String.format("Invoke timeout at server side, ignored to send response. service=%s method=%s cost=%s timeout=%s", invocation.getTargetServiceUniqueName(), invocation.getMethodName(), cost, timeoutVal));
                    UnaryServerStream.this.outboundTransportObserver().onError(GrpcStatus.fromCode(GrpcStatus.Code.DEADLINE_EXCEEDED));
                } else {
                    Metadata metadata = UnaryServerStream.this.createResponseMeta();
                    UnaryServerStream.this.outboundTransportObserver().onMetadata(metadata, false);
                    byte[] data = UnaryServerStream.this.encodeResponse(response.getValue());
                    if (data == null) {
                        return;
                    }
                    UnaryServerStream.this.outboundTransportObserver().onData(data, false);
                    Metadata trailers = TripleConstant.getSuccessResponseMeta();
                    UnaryServerStream.this.convertAttachment(trailers, response.getObjectAttachments());
                    UnaryServerStream.this.outboundTransportObserver().onMetadata(trailers, true);
                }
            });
            RpcContext.removeContext();
        }
    }
}

