/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import grpc.health.v1.Health;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.service.HealthStatusManager;
import org.apache.dubbo.rpc.protocol.tri.service.TriHealthImpl;

public class TriBuiltinService {
    private final ProxyFactory proxyFactory;
    private final PathResolver pathResolver;
    private final ModuleServiceRepository repository;
    private final Health healthService;
    private final HealthStatusManager healthStatusManager;
    private final AtomicBoolean init = new AtomicBoolean();

    public TriBuiltinService(FrameworkModel frameworkModel) {
        this.healthStatusManager = new HealthStatusManager(new TriHealthImpl());
        this.healthService = this.healthStatusManager.getHealthService();
        this.proxyFactory = (ProxyFactory)frameworkModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        this.pathResolver = (PathResolver)frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        this.repository = frameworkModel.getInternalApplicationModel().getInternalModule().getServiceRepository();
        this.init();
    }

    public void init() {
        if (this.init.compareAndSet(false, true)) {
            ServiceDescriptor serviceDescriptor = this.repository.registerService(Health.class);
            ServiceMetadata serviceMetadata = new ServiceMetadata();
            serviceMetadata.setServiceType(Health.class);
            serviceMetadata.setTarget((Object)this.healthService);
            serviceMetadata.setServiceInterfaceName(Health.class.getName());
            serviceMetadata.generateServiceKey();
            ProviderModel providerModel = new ProviderModel(Health.class.getName(), (Object)this.healthService, serviceDescriptor, null, serviceMetadata);
            this.repository.registerProvider(providerModel);
            int port = 0;
            ServiceConfigURL url = new ServiceConfigURL("tri", null, null, "0.0.0.0", port, Health.class.getName());
            url.setServiceModel((ServiceModel)providerModel);
            url.setScopeModel((ScopeModel)ApplicationModel.defaultModel().getInternalModule());
            Invoker invoker = this.proxyFactory.getInvoker((Object)this.healthService, Health.class, (URL)url);
            this.pathResolver.add(url.getServiceKey(), invoker);
            this.pathResolver.add(url.getServiceInterface(), invoker);
            providerModel.setDestroyCaller(() -> this.lambda$init$0((URL)url));
        }
    }

    public HealthStatusManager getHealthStatusManager() {
        return this.healthStatusManager;
    }

    private /* synthetic */ Void lambda$init$0(URL url) throws Exception {
        this.pathResolver.remove(url.getServiceKey());
        this.pathResolver.remove(url.getServiceInterface());
        return null;
    }
}

