package cn.com.duiba.api.bo.mq.alarmsms;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

/**
 * @Description: MQ处理参数（告警短信）
 * @Author: fxr
 * @Date: 2019/2/12
 */
public class AlarmSmsBaseParam implements Serializable {

    private static final long serialVersionUID = 5075793918337042920L;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 应用名称
     */
    private String appName;


    public AlarmSmsBaseParam() {
    }

    public AlarmSmsBaseParam(Long appId) {
        this.appId = appId;
    }

    public AlarmSmsBaseParam(String phone, String appName) {
        this.phone = phone;
        this.appName = appName;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return AlarmSmsBaseParam
     */
    public static <T> T decode(byte[] msg, Class<T> clazz) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, clazz);
    }

    /**
     * 校验对象是否存在空属性
     *
     * @param obj          对象
     * @param excludeNames 选择忽略校验的属性名称List集合
     * @return boolean
     * @throws Exception
     */
    public static boolean isExistNullField(Object obj, List<String> excludeNames) throws Exception {
        if (excludeNames == null) {
            excludeNames = Collections.emptyList();
        }
        Field[] fs = obj.getClass().getDeclaredFields();
        boolean flag = false;
        for (Field f : fs) {
            f.setAccessible(true);
            if (!excludeNames.contains(f.getName()) && (f.get(obj) == null || "".equals(f.get(obj).toString()))) {
                flag = true;
                break;
            }
        }
        return flag;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

