package cn.com.duiba.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 投放渠道
 * Created by xiaoxuda on 2019/3/12.
 */
public enum AppChannelTypeEnum {
    APP(1, "app端内"),
    WECHAT_PUBLIC(2, "微信公众号"),
    WECHAT_APP(3, "微信小程序"),
    OPEN(4, "开放式（不要求登录）"),
    ALIPAY(5, "支付宝小程序"),
    ;
    private Integer code;
    private String desc;

    private static Map<Integer, AppChannelTypeEnum> codeMap = new HashMap<>();
    static{
        for(AppChannelTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static AppChannelTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    AppChannelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
