package cn.com.duiba.api.tools;

import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/**
 * Created by xiaoxuda on 2019/1/14.
 */
public class DcustomParseUtil {
    private static Logger logger = LoggerFactory.getLogger(DcustomParseUtil.class);
    private static Pattern pattern = Pattern.compile(".*%[0-9A-z][0-9A-z].*");

    private static Splitter spl_prop = Splitter.on("&").trimResults().trimResults();
    private static Splitter spl = Splitter.on("=").trimResults().trimResults();

    public static Map<String, String> parseDcustom(String dcustom) {
        Map<String, String> map = new HashMap<>();
        try {
            if (StringUtils.isNotBlank(dcustom)) {
                if(!dcustom.contains("=")) {
                    dcustom = URLDecoder.decode(dcustom, "utf-8");
                }
                if(!dcustom.contains("=")) {//dcustom有过多次编码
                    dcustom = URLDecoder.decode(dcustom, "utf-8");
                }
                List<String> pairs = spl_prop.splitToList(dcustom);
                for (String p : pairs) {
                    List<String> ss = spl.splitToList(p);
                    if(ss.size()!=2){
                        continue;
                    }
                    if(ss.get(1).contains("%")) {
                        map.put(ss.get(0), parseValue(ss));
                    }else{
                        map.put(ss.get(0), ss.get(1));
                    }
                }
            }
        } catch (Exception e) {
            logger.info("dcustom 解析出错, dcustom={}, err={}", dcustom, e.getMessage());
        }
        return map;
    }

    private static String parseValue(List<String> ss){
        String val = ss.get(1);
        try {
            if(pattern.matcher(val).matches()) {
                val = URLDecoder.decode(val, "utf-8");
            }
        } catch (UnsupportedEncodingException e) {
            logger.info("DcustomParseUtil.parseValue, key={}, val={}, err={}", ss.get(0), ss.get(1), e.getMessage());
        }
        return val;
    }

}
