package cn.com.duiba.api.tools.abc;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * @author qianjue
 * @date 2019/9/25
 * @description: 农业银行接口请求解析工具类
 */
public class ResponseAnalysis4ABCUtils {

    /**
     * 农业银行请求解析类，对方默认返回的请求分为2层
     * 通过解析类将里面双层json转化成一层json，方面上层业务迅速判断和处理
     * [重要]使用中要结合具体的接口来使用，外层级和内层级不得出现key值相同的情况
     * 举例，原始数据为：
     * {
     *     "status": "success",
     *     "result": {
     *         "returncode": "000000",
     *         "returnmsg": "交易成功",
     *         "numBean": 1000
     *     }
     * }
     * 经过该方法处理后的数据为
     * {
     *     "status": "success",
     *     "returncode": "000000",
     *     "returnmsg": "交易成功",
     *     "numBean": 1000
     * }
     * @param response
     * @return
     */
    public static JSONObject analysisResponse(String response){
        JSONObject ret = new JSONObject();
        JSONObject origin = JSONObject.parseObject(response);
        if(null == origin){
            return ret;
        }
        for(Map.Entry<String, Object> entry : origin.entrySet()){
            if(entry.getValue() instanceof JSONObject){
                JSONObject childObject = (JSONObject) entry.getValue();
                for(Map.Entry<String, Object> child : childObject.entrySet()){
                    ret.put(child.getKey(),child.getValue());
                }
            }else{
                ret.put(entry.getKey(),entry.getValue());
            }
        }
        return ret;
    }

}
