/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api.tools;

import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcustomParseUtil {
    private static Logger logger = LoggerFactory.getLogger(DcustomParseUtil.class);
    private static Pattern pattern = Pattern.compile(".*%[0-9A-z][0-9A-z].*");
    private static Splitter spl_prop = Splitter.on((String)"&").trimResults().trimResults();
    private static Splitter spl = Splitter.on((String)"=").trimResults().trimResults();

    public static Map<String, String> parseDcustom(String dcustom) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isNotBlank((String)dcustom)) {
                if (!dcustom.contains("=")) {
                    dcustom = URLDecoder.decode(dcustom, "utf-8");
                }
                if (!dcustom.contains("=")) {
                    dcustom = URLDecoder.decode(dcustom, "utf-8");
                }
                List pairs = spl_prop.splitToList((CharSequence)dcustom);
                for (String p : pairs) {
                    List ss = spl.splitToList((CharSequence)p);
                    if (ss.size() != 2) continue;
                    if (((String)ss.get(1)).contains("%")) {
                        map.put((String)ss.get(0), DcustomParseUtil.parseValue(ss));
                        continue;
                    }
                    map.put((String)ss.get(0), (String)ss.get(1));
                }
            }
        }
        catch (Exception e) {
            logger.info("dcustom \u89e3\u6790\u51fa\u9519, dcustom={}, err={}", (Object)dcustom, (Object)e.getMessage());
        }
        return map;
    }

    private static String parseValue(List<String> ss) {
        String val = ss.get(1);
        try {
            if (pattern.matcher(val).matches()) {
                val = URLDecoder.decode(val, "utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info("DcustomParseUtil.parseValue, key={}, val={}, err={}", new Object[]{ss.get(0), ss.get(1), e.getMessage()});
        }
        return val;
    }
}

