package cn.com.duiba.duiba.base.service.api.duibaboot.oss.template;

import org.apache.commons.lang.StringUtils;

import java.net.URI;

/**
 * @author dugq
 * @date 2021/7/21 4:02 下午
 */
public class PrivateBucketOssTemplate extends AbstractOssTemplate{

    @Override
    public void afterPropertiesSet() throws Exception {
        URI uri = URI.create(endPoint);
        bucketHost = bucketName+"."+uri.getHost();
        bucketDomain = uri.getScheme()+"://"+bucketHost;
    }

    @Override
    public String getUrl(String key) {
        if (StringUtils.isBlank(key)){
            return key;
        }
        String host = getBucketHost();
        //e.g: https://yun.kjjcrm.com/object/name.html
        if (key.startsWith("http")){
            return key;
        }
        //e.g: //yun.kjjcrm.com/object/name.html
        if (key.startsWith("//")){
            return "https:"+key;
        }
        //e.g: yun.kjjcrm.com/object/name.html
        if (key.startsWith(host)){
            return "https://"+key;
        }
        //e.g: /object/name.html
        if (key.startsWith("/")){
            return "https://"+host+key;
        }
        //e.g: object/name.html
        return "https://"+host+"/"+key;
    }

}
