package cn.com.duiba.duiba.base.service.api.tool.impl;

import cn.com.duiba.duiba.base.service.api.tool.RegionCodeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 地区编码
 *
 * @author xuzhigang
 * @date 2021/5/26 5:07 下午
 **/

public class RegionCodeServiceImpl implements RegionCodeService {

    private final Map<String, String> regionCodeMap = new HashMap<>(3600);

    public RegionCodeServiceImpl() {
        loadLocalCache();
    }

    private void loadLocalCache() {
        List<String> lines;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/phone_location.csv");
            lines = new BufferedReader(new InputStreamReader(inputStream))
                    .lines().collect(Collectors.toList());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        // 按行读取csv文件
        if (CollectionUtils.isEmpty(lines)) {
            return;
        }
        lines.forEach(line -> {
            String[] split = StringUtils.split(line, ",");
            if (Objects.isNull(split) || split.length != 2) {
                return;
            }
            String regionName = split[0];
            String regionCode = split[1];
            regionCodeMap.put(regionCode, regionName);
        });
    }

    @Override
    public String getRegionNameByCode(String regionCode) {
        if (StringUtils.isBlank(regionCode)) {
            return null;
        }
        return regionCodeMap.get(regionCode);
    }
}
